/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.storage.AEKeyFilter;
import appeng.util.ConfigInventory;
import com.google.common.base.Preconditions;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class CellConfig {
    private CellConfig() {
    }

    public static ConfigInventory create(@Nullable AEKeyFilter filter, ItemStack is, int size) {
        Preconditions.checkArgument((size >= 1 && size <= 63 ? 1 : 0) != 0, (Object)"Config inventory must have between 1 and 63 slots inclusive.");
        Holder holder = new Holder(is);
        holder.inv = ConfigInventory.configTypes(filter, size, holder::save);
        holder.load();
        return holder.inv;
    }

    public static ConfigInventory create(@Nullable AEKeyFilter filter, ItemStack is) {
        Holder holder = new Holder(is);
        holder.inv = ConfigInventory.configTypes(filter, 63, holder::save);
        holder.load();
        return holder.inv;
    }

    public static ConfigInventory create(ItemStack is) {
        Holder holder = new Holder(is);
        holder.inv = ConfigInventory.configTypes(null, 63, holder::save);
        holder.load();
        return holder.inv;
    }

    private static class Holder {
        private final ItemStack stack;
        private ConfigInventory inv;

        public Holder(ItemStack stack) {
            this.stack = stack;
        }

        public void load() {
            if (this.stack.hasTag()) {
                this.inv.readFromChildTag(this.stack.getOrCreateTag(), "list");
            }
        }

        public void save() {
            this.inv.writeToChildTag(this.stack.getOrCreateTag(), "list");
        }
    }
}

