/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.items.parts.FacadeItem;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

class FacadeRegistryPlugin
implements IRecipeManagerPlugin {
    private final FacadeItem itemFacade;
    private final ItemStack cableAnchor;

    FacadeRegistryPlugin(FacadeItem itemFacade, ItemStack cableAnchor) {
        this.itemFacade = itemFacade;
        this.cableAnchor = cableAnchor;
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        ItemStack stackFocus = focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        if (focus.getRole() == RecipeIngredientRole.OUTPUT && stackFocus != null ? stackFocus.getItem() instanceof FacadeItem : focus.getRole() == RecipeIngredientRole.INPUT && stackFocus != null && !this.itemFacade.createFacadeForItem(stackFocus, true).isEmpty()) {
            return Collections.singletonList(RecipeTypes.CRAFTING);
        }
        return Collections.emptyList();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ItemStack facade;
        if (!RecipeTypes.CRAFTING.equals((Object)recipeCategory.getRecipeType())) {
            return Collections.emptyList();
        }
        ItemStack focusStack = focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(null);
        if (focus.getRole() == RecipeIngredientRole.OUTPUT && focusStack != null) {
            Item item = focusStack.getItem();
            if (item instanceof FacadeItem) {
                FacadeItem facadeItem = (FacadeItem)item;
                ItemStack textureItem = facadeItem.getTextureItem(focusStack);
                return Collections.singletonList(this.make(textureItem, this.cableAnchor, focusStack));
            }
        } else if (focus.getRole() == RecipeIngredientRole.INPUT && focusStack != null && !(facade = this.itemFacade.createFacadeForItem(focusStack, false)).isEmpty()) {
            return Collections.singletonList(this.make(focusStack, this.cableAnchor, facade));
        }
        return Collections.emptyList();
    }

    private ShapedRecipe make(ItemStack textureItem, ItemStack cableAnchor, ItemStack result) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)textureItem.getItem());
        ResourceLocation id = new ResourceLocation("ae2", "facade/" + itemId.getNamespace() + "/" + itemId.getPath());
        NonNullList ingredients = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        ingredients.set(1, (Object)Ingredient.of((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(3, (Object)Ingredient.of((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(5, (Object)Ingredient.of((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(7, (Object)Ingredient.of((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(4, (Object)Ingredient.of((ItemStack[])new ItemStack[]{textureItem}));
        ItemStack output = result.copy();
        output.setCount(4);
        return new ShapedRecipe(id, "", CraftingBookCategory.MISC, 3, 3, ingredients, output);
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }
}

