/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.implementations.items.IStorageComponent;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.integration.modules.jei.IconDrawable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

class CondenserCategory
implements IRecipeCategory<CondenserOutput> {
    private static final String TITLE_TRANSLATION_KEY = "block.ae2.condenser";
    public static final RecipeType<CondenserOutput> RECIPE_TYPE = RecipeType.create((String)"ae2", (String)"condenser", CondenserOutput.class);
    private final IDrawable background;
    private final IDrawableAnimated progress;
    private final IDrawable iconButton;
    private final IDrawable iconTrash;
    private final IDrawable icon;
    private final Map<CondenserOutput, IDrawable> buttonIcons;

    public CondenserCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AEBlocks.CONDENSER.stack());
        ResourceLocation location = new ResourceLocation("ae2", "textures/guis/condenser.png");
        this.background = guiHelper.createDrawable(location, 50, 25, 94, 48);
        this.iconTrash = new IconDrawable(Icon.BACKGROUND_TRASH, 1, 27);
        this.iconButton = new IconDrawable(Icon.TOOLBAR_BUTTON_BACKGROUND, 78, 26);
        IDrawableStatic progressDrawable = guiHelper.drawableBuilder(location, 178, 25, 6, 18).addPadding(0, 0, 70, 0).build();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.buttonIcons = new EnumMap<CondenserOutput, IDrawable>(CondenserOutput.class);
        this.buttonIcons.put(CondenserOutput.MATTER_BALLS, new IconDrawable(Icon.CONDENSER_OUTPUT_MATTER_BALL, 78, 26));
        this.buttonIcons.put(CondenserOutput.SINGULARITY, new IconDrawable(Icon.CONDENSER_OUTPUT_SINGULARITY, 78, 26));
    }

    private ItemStack getOutput(CondenserOutput recipe) {
        return switch (recipe) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> ItemStack.EMPTY;
        };
    }

    public RecipeType<CondenserOutput> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)TITLE_TRANSLATION_KEY);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CondenserOutput recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.progress.draw(guiGraphics);
        this.iconTrash.draw(guiGraphics);
        this.iconButton.draw(guiGraphics);
        IDrawable buttonIcon = this.buttonIcons.get((Object)recipe);
        if (buttonIcon != null) {
            buttonIcon.draw(guiGraphics);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CondenserOutput recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 27).setSlotName("output").addItemStack(this.getOutput(recipe));
        builder.addSlot(RecipeIngredientRole.CATALYST, 51, 1).setSlotName("storage_cell").addItemStacks(this.getViableStorageComponents(recipe));
    }

    private List<ItemStack> getViableStorageComponents(CondenserOutput condenserOutput) {
        ArrayList<ItemStack> viableComponents = new ArrayList<ItemStack>();
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_1K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_4K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_16K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_64K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_256K.stack());
        return viableComponents;
    }

    private void addViableComponent(CondenserOutput condenserOutput, List<ItemStack> viableComponents, ItemStack itemStack) {
        IStorageComponent comp = (IStorageComponent)itemStack.getItem();
        int storage = comp.getBytes(itemStack) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add(itemStack);
        }
    }

    public List<Component> getTooltipStrings(CondenserOutput recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 28.0 && mouseX < 44.0 && mouseY >= 78.0 && mouseY < 94.0) {
            String key;
            switch (recipe) {
                case MATTER_BALLS: {
                    key = "gui.tooltips.appliedenergistics2.MatterBalls";
                    break;
                }
                case SINGULARITY: {
                    key = "gui.tooltips.appliedenergistics2.Singularity";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Lists.newArrayList((Object[])new Component[]{Component.translatable((String)key)});
        }
        return Collections.emptyList();
    }
}

