/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.parts;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.core.localization.InGameTooltip;
import appeng.parts.automation.AnnihilationPlanePart;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;

public class AnnihilationPlaneDataProvider
implements BodyProvider<AnnihilationPlanePart>,
ServerDataProvider<AnnihilationPlanePart> {
    private static final String TAG_ENCHANTMENTS = "planeEnchantments";

    @Override
    public void buildTooltip(AnnihilationPlanePart plane, TooltipContext context, TooltipBuilder tooltip) {
        CompoundTag serverData = context.serverData();
        if (serverData.contains(TAG_ENCHANTMENTS, 10)) {
            tooltip.addLine((Component)InGameTooltip.EnchantedWith.text());
            CompoundTag enchantments = serverData.getCompound(TAG_ENCHANTMENTS);
            for (String enchantmentId : enchantments.getAllKeys()) {
                Enchantment enchantment = (Enchantment)BuiltInRegistries.ENCHANTMENT.get(new ResourceLocation(enchantmentId));
                int level = enchantments.getInt(enchantmentId);
                if (enchantment == null) continue;
                tooltip.addLine(enchantment.getFullname(level));
            }
        }
    }

    @Override
    public void provideServerData(Player player, AnnihilationPlanePart plane, CompoundTag serverData) {
        Map<Enchantment, Integer> enchantments = plane.getEnchantments();
        if (enchantments != null && !enchantments.isEmpty()) {
            CompoundTag enchantmentsTag = new CompoundTag();
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                ResourceLocation id = BuiltInRegistries.ENCHANTMENT.getKey((Object)entry.getKey());
                if (id == null) continue;
                enchantmentsTag.putInt(id.toString(), entry.getValue().intValue());
            }
            serverData.put(TAG_ENCHANTMENTS, (Tag)enchantmentsTag);
        }
    }
}

