/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.worldgen;

import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public final class InitStructures {
    private InitStructures() {
    }

    public static void initDatagenStructures(BootstapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(MeteoriteStructure.KEY, (Object)new MeteoriteStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MeteoriteStructure.BIOME_TAG_KEY), Map.of(), GenerationStep.Decoration.TOP_LAYER_MODIFICATION, TerrainAdjustment.NONE)));
    }

    public static void initDatagenStructureSets(BootstapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        Holder.Reference meteorite = structures.getOrThrow(MeteoriteStructure.KEY);
        StructureSet structureSet = new StructureSet(List.of(StructureSet.entry((Holder)meteorite)), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 124895654));
        context.register(MeteoriteStructure.STRUCTURE_SET_KEY, (Object)structureSet);
    }

    public static void init() {
        MeteoriteStructurePiece.register();
        MeteoriteStructure.TYPE = StructureType.register((String)"ae2mtrt", MeteoriteStructure.CODEC);
    }
}

