/*
 * Decompiled with CFR 0.152.
 */
package appeng.hotkeys;

import appeng.api.features.HotkeyAction;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.hotkeys.InventoryHotkeyAction;
import appeng.items.tools.powered.AbstractPortableCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HotkeyActions {
    public static final Map<String, List<HotkeyAction>> REGISTRY = new HashMap<String, List<HotkeyAction>>();

    public static void init() {
        HotkeyActions.register(new InventoryHotkeyAction(AEItems.WIRELESS_TERMINAL.asItem(), (player, i) -> AEItems.WIRELESS_TERMINAL.asItem().openFromInventory(player, i)), "wireless_terminal");
        HotkeyActions.register(new InventoryHotkeyAction(AEItems.WIRELESS_CRAFTING_TERMINAL.asItem(), (player, i) -> AEItems.WIRELESS_CRAFTING_TERMINAL.asItem().openFromInventory(player, i)), "wireless_terminal");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL1K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL4K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL16K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL64K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL256K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL1K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL4K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL16K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL64K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL256K, "portable_fluid_cell");
    }

    public static void registerPortableCell(ItemDefinition<? extends AbstractPortableCell> cell, String id) {
        HotkeyActions.register(new InventoryHotkeyAction(cell.asItem(), cell.asItem()::openFromInventory), id);
    }

    public static synchronized void register(HotkeyAction hotkeyAction, String id) {
        if (REGISTRY.containsKey(id)) {
            REGISTRY.get(id).add(0, hotkeyAction);
        } else {
            REGISTRY.put(id, new ArrayList<HotkeyAction>(List.of(hotkeyAction)));
            AppEng.instance().registerHotkey(id);
        }
    }
}

