/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BuiltInModelHooks {
    private static final Map<ResourceLocation, UnbakedModel> builtInModels = new HashMap<ResourceLocation, UnbakedModel>();

    private BuiltInModelHooks() {
    }

    public static void addBuiltInModel(ResourceLocation id, UnbakedModel model) {
        if (builtInModels.put(id, model) != null) {
            throw new IllegalStateException("Duplicate built-in model ID: " + id);
        }
    }

    @Nullable
    public static UnbakedModel getBuiltInModel(ResourceLocation variantId) {
        if (!"ae2".equals(variantId.getNamespace())) {
            return null;
        }
        if (variantId instanceof ModelResourceLocation) {
            ModelResourceLocation modelId = (ModelResourceLocation)variantId;
            if ("inventory".equals(modelId.getVariant())) {
                ResourceLocation itemModelId = new ResourceLocation(modelId.getNamespace(), "item/" + modelId.getPath());
                return builtInModels.get(itemModelId);
            }
            return null;
        }
        return builtInModels.get(variantId);
    }
}

