/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageService;
import appeng.api.storage.MEStorage;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.IConfigManager;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.ISubMenu;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WirelessTerminalMenuHost
extends ItemMenuHost
implements IPortableTerminal,
IActionHost {
    private final WirelessTerminalItem terminal;
    private final BiConsumer<Player, ISubMenu> returnToMainMenu;
    private final IGrid targetGrid;
    private IStorageService sg;
    @Nullable
    private IWirelessAccessPoint myWap;
    private double currentDistanceFromGrid = Double.MAX_VALUE;

    public WirelessTerminalMenuHost(Player player, @Nullable Integer slot, ItemStack itemStack, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(player, slot, itemStack);
        Item item = itemStack.getItem();
        if (!(item instanceof WirelessTerminalItem)) {
            throw new IllegalArgumentException("Can only use this class with subclasses of WirelessTerminalItem");
        }
        WirelessTerminalItem wirelessTerminalItem = (WirelessTerminalItem)item;
        this.terminal = wirelessTerminalItem;
        this.returnToMainMenu = returnToMainMenu;
        this.targetGrid = wirelessTerminalItem.getLinkedGrid(itemStack, player.level(), player);
        if (this.targetGrid != null) {
            this.sg = this.targetGrid.getStorageService();
        }
    }

    @Override
    public MEStorage getInventory() {
        return this.sg != null ? this.sg.getInventory() : null;
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        if (this.terminal != null) {
            double extracted = Math.min(amt, this.terminal.getAECurrentPower(this.getItemStack()));
            if (mode == Actionable.SIMULATE) {
                return extracted;
            }
            return this.terminal.usePower(this.getPlayer(), extracted, this.getItemStack()) ? extracted : 0.0;
        }
        return 0.0;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.terminal.getConfigManager(this.getItemStack());
    }

    @Override
    public IGridNode getActionableNode() {
        this.rangeCheck();
        if (this.myWap != null) {
            return this.myWap.getActionableNode();
        }
        return null;
    }

    public boolean rangeCheck() {
        this.currentDistanceFromGrid = Double.MAX_VALUE;
        if (this.targetGrid != null) {
            @Nullable WirelessAccessPointBlockEntity bestWap = null;
            double bestSqDistance = Double.MAX_VALUE;
            for (WirelessAccessPointBlockEntity wap : this.targetGrid.getMachines(WirelessAccessPointBlockEntity.class)) {
                double sqDistance = this.getWapSqDistance(wap);
                if (!(sqDistance < bestSqDistance)) continue;
                bestSqDistance = sqDistance;
                bestWap = wap;
            }
            this.myWap = bestWap;
            this.currentDistanceFromGrid = Math.sqrt(bestSqDistance);
            return this.myWap != null;
        }
        return false;
    }

    protected double getWapSqDistance(IWirelessAccessPoint wap) {
        double offZ;
        double offY;
        double offX;
        double r;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() == this.getPlayer().level() && (r = (offX = (double)dc.getPos().getX() - this.getPlayer().getX()) * offX + (offY = (double)dc.getPos().getY() - this.getPlayer().getY()) * offY + (offZ = (double)dc.getPos().getZ() - this.getPlayer().getZ()) * offZ) < rangeLimit && wap.isActive()) {
            return r;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean onBroadcastChanges(AbstractContainerMenu menu) {
        return super.onBroadcastChanges(menu) && this.checkWirelessRange(menu) && this.drainPower();
    }

    private boolean checkWirelessRange(AbstractContainerMenu menu) {
        if (!this.rangeCheck()) {
            if (!this.isClientSide()) {
                this.getPlayer().displayClientMessage((Component)PlayerMessages.OutOfRange.text(), true);
            }
            return false;
        }
        this.setPowerDrainPerTick(AEConfig.instance().wireless_getDrainRate(this.currentDistanceFromGrid));
        return true;
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        this.returnToMainMenu.accept(player, subMenu);
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }

    @Override
    public String getCloseHotkey() {
        return "wireless_terminal";
    }
}

