/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.AELog;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChunkLoaderBlockEntity
extends AEBaseBlockEntity
implements ServerTickingBlockEntity {
    public ChunkLoaderBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ChunkPos chunkPos = new ChunkPos(this.getBlockPos());
            ((ServerLevel)level).setChunkForced(chunkPos.x, chunkPos.z, true);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ChunkPos chunkPos = new ChunkPos(this.getBlockPos());
            ((ServerLevel)level).setChunkForced(chunkPos.x, chunkPos.z, false);
        }
    }

    @Override
    public void serverTick() {
        ServerLevel serverLevel = (ServerLevel)this.getLevel();
        ChunkPos chunkPos = new ChunkPos(this.getBlockPos());
        if (!serverLevel.getForcedChunks().contains(chunkPos.toLong())) {
            AELog.debug("Force-loading chunk @ %d,%d in %s", chunkPos.x, chunkPos.z, serverLevel.dimension());
            serverLevel.setChunkForced(chunkPos.x, chunkPos.z, false);
        }
    }
}

