/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.tags;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.ids.AETags;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.ConventionTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemTagsProvider
extends net.minecraft.data.tags.ItemTagsProvider
implements IAE2DataProvider {
    public ItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, blockTagsProvider, "ae2", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.copyBlockTags();
        this.tag(ConventionTags.COPPER_INGOT).add((Object)Items.COPPER_INGOT);
        this.tag(AETags.ANNIHILATION_PLANE_ITEM_BLACKLIST);
        this.tag(ConventionTags.BUDDING_BLOCKS).add((Object)Items.BUDDING_AMETHYST).add(AEBlocks.FLAWLESS_BUDDING_QUARTZ.asItem()).add(AEBlocks.FLAWED_BUDDING_QUARTZ.asItem()).add(AEBlocks.CHIPPED_BUDDING_QUARTZ.asItem()).add(AEBlocks.DAMAGED_BUDDING_QUARTZ.asItem());
        this.tag(ConventionTags.BUDS).add(AEBlocks.SMALL_QUARTZ_BUD.asItem()).add(AEBlocks.MEDIUM_QUARTZ_BUD.asItem()).add(AEBlocks.LARGE_QUARTZ_BUD.asItem());
        this.tag(ConventionTags.CLUSTERS).add(AEBlocks.QUARTZ_CLUSTER.asItem());
        this.tag(ConventionTags.CERTUS_QUARTZ_DUST).add((Object)AEItems.CERTUS_QUARTZ_DUST.asItem());
        this.tag(ConventionTags.ENDER_PEARL_DUST).add((Object)AEItems.ENDER_DUST.asItem());
        this.tag(ConventionTags.ALL_QUARTZ_DUST).addTag(ConventionTags.CERTUS_QUARTZ_DUST);
        this.tag(ConventionTags.ALL_CERTUS_QUARTZ).addTag(ConventionTags.CERTUS_QUARTZ).add((Object)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.asItem());
        this.tag(ConventionTags.ALL_FLUIX).add((Object)AEItems.FLUIX_CRYSTAL.asItem());
        this.tag(ConventionTags.ALL_NETHER_QUARTZ).addTag(ConventionTags.NETHER_QUARTZ);
        this.tag(ConventionTags.ALL_QUARTZ).addTag(ConventionTags.NETHER_QUARTZ).addTag(ConventionTags.CERTUS_QUARTZ).add((Object)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.asItem());
        for (AEColor color : AEColor.values()) {
            this.tag(ConventionTags.SMART_DENSE_CABLE).add(AEParts.SMART_DENSE_CABLE.item(color));
            this.tag(ConventionTags.SMART_CABLE).add(AEParts.SMART_CABLE.item(color));
            this.tag(ConventionTags.GLASS_CABLE).add(AEParts.GLASS_CABLE.item(color));
            this.tag(ConventionTags.COVERED_CABLE).add(AEParts.COVERED_CABLE.item(color));
            this.tag(ConventionTags.COVERED_DENSE_CABLE).add(AEParts.COVERED_DENSE_CABLE.item(color));
        }
        this.tag(ConventionTags.INSCRIBER_PRESSES).add((Object)AEItems.CALCULATION_PROCESSOR_PRESS.asItem()).add((Object)AEItems.ENGINEERING_PROCESSOR_PRESS.asItem()).add((Object)AEItems.LOGIC_PROCESSOR_PRESS.asItem()).add((Object)AEItems.SILICON_PRESS.asItem());
        for (AEColor color : AEColor.VALID_COLORS) {
            this.tag(ConventionTags.PAINT_BALLS).add((Object)AEItems.COLORED_PAINT_BALL.item(color));
        }
        this.tag(ConventionTags.SILICON).add((Object)AEItems.SILICON.asItem());
        this.tag(ConventionTags.QUARTZ_AXE).add((Object)AEItems.CERTUS_QUARTZ_AXE.asItem()).add((Object)AEItems.NETHER_QUARTZ_AXE.asItem());
        this.tag(ConventionTags.QUARTZ_HOE).add((Object)AEItems.CERTUS_QUARTZ_HOE.asItem()).add((Object)AEItems.NETHER_QUARTZ_HOE.asItem());
        this.tag(ConventionTags.QUARTZ_PICK).add((Object)AEItems.CERTUS_QUARTZ_PICK.asItem()).add((Object)AEItems.NETHER_QUARTZ_PICK.asItem());
        this.tag(ConventionTags.QUARTZ_SHOVEL).add((Object)AEItems.CERTUS_QUARTZ_SHOVEL.asItem()).add((Object)AEItems.NETHER_QUARTZ_SHOVEL.asItem());
        this.tag(ConventionTags.QUARTZ_SWORD).add((Object)AEItems.CERTUS_QUARTZ_SWORD.asItem()).add((Object)AEItems.NETHER_QUARTZ_SWORD.asItem());
        this.tag(ConventionTags.QUARTZ_WRENCH).add((Object)AEItems.CERTUS_QUARTZ_WRENCH.asItem()).add((Object)AEItems.NETHER_QUARTZ_WRENCH.asItem());
        this.tag(ConventionTags.QUARTZ_KNIFE).add((Object)AEItems.CERTUS_QUARTZ_KNIFE.asItem()).add((Object)AEItems.NETHER_QUARTZ_KNIFE.asItem());
        this.tag(ItemTags.AXES).add((Object)AEItems.CERTUS_QUARTZ_AXE.asItem()).add((Object)AEItems.NETHER_QUARTZ_AXE.asItem()).add((Object)AEItems.FLUIX_AXE.asItem());
        this.tag(ItemTags.HOES).add((Object)AEItems.CERTUS_QUARTZ_HOE.asItem()).add((Object)AEItems.NETHER_QUARTZ_HOE.asItem()).add((Object)AEItems.FLUIX_HOE.asItem());
        this.tag(ItemTags.PICKAXES).add((Object)AEItems.CERTUS_QUARTZ_PICK.asItem()).add((Object)AEItems.NETHER_QUARTZ_PICK.asItem()).add((Object)AEItems.FLUIX_PICK.asItem());
        this.tag(ItemTags.SHOVELS).add((Object)AEItems.CERTUS_QUARTZ_SHOVEL.asItem()).add((Object)AEItems.NETHER_QUARTZ_SHOVEL.asItem()).add((Object)AEItems.FLUIX_SHOVEL.asItem());
        this.tag(ItemTags.SWORDS).add((Object)AEItems.CERTUS_QUARTZ_SWORD.asItem()).add((Object)AEItems.NETHER_QUARTZ_SWORD.asItem()).add((Object)AEItems.FLUIX_SWORD.asItem());
        this.tag(ConventionTags.WRENCH).add((Object[])new Item[]{AEItems.CERTUS_QUARTZ_WRENCH.asItem(), AEItems.NETHER_QUARTZ_WRENCH.asItem(), AEItems.NETWORK_TOOL.asItem()});
        this.tag(AETags.METAL_INGOTS).addOptionalTag(new ResourceLocation("forge:ingots/copper")).addOptionalTag(new ResourceLocation("forge:ingots/tin")).addOptionalTag(new ResourceLocation("forge:ingots/iron")).addOptionalTag(new ResourceLocation("forge:ingots/gold")).addOptionalTag(new ResourceLocation("forge:ingots/brass")).addOptionalTag(new ResourceLocation("forge:ingots/nickel")).addOptionalTag(new ResourceLocation("forge:ingots/aluminium"));
        this.tag(ConventionTags.PATTERN_PROVIDER).add(AEParts.PATTERN_PROVIDER.asItem()).add(AEBlocks.PATTERN_PROVIDER.asItem());
        this.tag(ConventionTags.INTERFACE).add(AEParts.INTERFACE.asItem()).add(AEBlocks.INTERFACE.asItem());
        this.tag(ConventionTags.ILLUMINATED_PANEL).add(AEParts.MONITOR.asItem()).add(AEParts.SEMI_DARK_MONITOR.asItem()).add(AEParts.DARK_MONITOR.asItem());
        this.tag(ConventionTags.FLUIX_DUST).add((Object)AEItems.FLUIX_DUST.asItem());
        this.tag(ConventionTags.CERTUS_QUARTZ_DUST).add((Object)AEItems.CERTUS_QUARTZ_DUST.asItem());
        this.tag(ConventionTags.FLUIX_CRYSTAL).add((Object)AEItems.FLUIX_CRYSTAL.asItem());
        this.tag(ConventionTags.CERTUS_QUARTZ).add((Object)AEItems.CERTUS_QUARTZ_CRYSTAL.asItem()).add((Object)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.asItem());
        this.tag(ConventionTags.DUSTS).add((Object)AEItems.CERTUS_QUARTZ_DUST.asItem()).add((Object)AEItems.ENDER_DUST.asItem()).add((Object)AEItems.FLUIX_DUST.asItem()).add((Object)AEItems.SKY_DUST.asItem());
        this.tag(ConventionTags.GEMS).add((Object)AEItems.CERTUS_QUARTZ_CRYSTAL.asItem()).add((Object)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.asItem()).add((Object)AEItems.FLUIX_CRYSTAL.asItem());
        this.tag(ConventionTags.WRENCH).add((Object[])new Item[]{AEItems.CERTUS_QUARTZ_WRENCH.asItem(), AEItems.NETHER_QUARTZ_WRENCH.asItem(), AEItems.NETWORK_TOOL.asItem()});
        this.tag(ConventionTags.CAN_REMOVE_COLOR).add((Object[])new Item[]{Items.WATER_BUCKET, Items.SNOWBALL});
        this.tag(ConventionTags.WRENCH).addOptional(new ResourceLocation("immersiveengineering:hammer"));
        this.addP2pAttunementTags();
    }

    private void copyBlockTags() {
        this.mirrorBlockTag(Tags.Blocks.STORAGE_BLOCKS.location());
        this.mirrorBlockTag(new ResourceLocation("forge:storage_blocks/certus_quartz"));
    }

    private void mirrorBlockTag(ResourceLocation tagName) {
        this.copy(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagName), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagName));
    }

    private void addP2pAttunementTags() {
        this.tag(P2PTunnelAttunement.getAttunementTag(P2PTunnelAttunement.LIGHT_TUNNEL)).add((Object[])new Item[]{Items.TORCH, Items.GLOWSTONE});
        this.tag(P2PTunnelAttunement.getAttunementTag(P2PTunnelAttunement.ENERGY_TUNNEL)).add((Object[])new Item[]{AEBlocks.DENSE_ENERGY_CELL.asItem(), AEBlocks.ENERGY_ACCEPTOR.asItem(), AEBlocks.ENERGY_CELL.asItem(), AEBlocks.CREATIVE_ENERGY_CELL.asItem()});
        this.tag(P2PTunnelAttunement.getAttunementTag(P2PTunnelAttunement.REDSTONE_TUNNEL)).add((Object[])new Item[]{Items.REDSTONE, Items.REPEATER, Items.REDSTONE_LAMP, Items.COMPARATOR, Items.DAYLIGHT_DETECTOR, Items.REDSTONE_TORCH, Items.REDSTONE_BLOCK, Items.LEVER});
        this.tag(P2PTunnelAttunement.getAttunementTag(P2PTunnelAttunement.ITEM_TUNNEL)).add((Object[])new Item[]{AEParts.STORAGE_BUS.asItem(), AEParts.EXPORT_BUS.asItem(), AEParts.IMPORT_BUS.asItem(), Items.HOPPER, Items.CHEST, Items.TRAPPED_CHEST}).addTag(ConventionTags.INTERFACE);
        this.tag(P2PTunnelAttunement.getAttunementTag(P2PTunnelAttunement.FLUID_TUNNEL)).add((Object[])new Item[]{Items.BUCKET, Items.MILK_BUCKET, Items.WATER_BUCKET, Items.LAVA_BUCKET});
        this.tag(P2PTunnelAttunement.getAttunementTag(P2PTunnelAttunement.ME_TUNNEL)).addTag(ConventionTags.COVERED_CABLE).addTag(ConventionTags.COVERED_DENSE_CABLE).addTag(ConventionTags.GLASS_CABLE).addTag(ConventionTags.SMART_CABLE).addTag(ConventionTags.SMART_DENSE_CABLE);
    }
}

