/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.recipes;

import appeng.core.AppEng;
import appeng.datagen.providers.recipes.AE2RecipeProvider;
import appeng.recipes.entropy.EntropyRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EntropyRecipes
extends AE2RecipeProvider {
    public EntropyRecipes(PackOutput output) {
        super(output);
    }

    public void buildRecipes(Consumer<FinishedRecipe> consumer) {
        this.buildCoolRecipes(consumer);
        this.buildHeatRecipes(consumer);
    }

    private void buildCoolRecipes(Consumer<FinishedRecipe> consumer) {
        EntropyRecipeBuilder.cool(AppEng.makeId("entropy/cool/flowing_water_snowball")).setInputFluid((Fluid)Fluids.FLOWING_WATER).setDrops(new ItemStack((ItemLike)Items.SNOWBALL)).save(consumer);
        EntropyRecipeBuilder.cool(AppEng.makeId("entropy/cool/grass_block_dirt")).setInputBlock(Blocks.GRASS_BLOCK).setOutputBlock(Blocks.DIRT).save(consumer);
        EntropyRecipeBuilder.cool(AppEng.makeId("entropy/cool/lava_obsidian")).setInputFluid((Fluid)Fluids.LAVA).setOutputBlock(Blocks.OBSIDIAN).save(consumer);
        EntropyRecipeBuilder.cool(AppEng.makeId("entropy/cool/stone_bricks_cracked_stone_bricks")).setInputBlock(Blocks.STONE_BRICKS).setOutputBlock(Blocks.CRACKED_STONE_BRICKS).save(consumer);
        EntropyRecipeBuilder.cool(AppEng.makeId("entropy/cool/stone_cobblestone")).setInputBlock(Blocks.STONE).setOutputBlock(Blocks.COBBLESTONE).save(consumer);
        EntropyRecipeBuilder.cool(AppEng.makeId("entropy/cool/water_ice")).setInputFluid((Fluid)Fluids.WATER).setOutputBlock(Blocks.ICE).save(consumer);
    }

    private void buildHeatRecipes(Consumer<FinishedRecipe> consumer) {
        EntropyRecipeBuilder.heat(AppEng.makeId("entropy/heat/cobblestone_stone")).setInputBlock(Blocks.COBBLESTONE).setOutputBlock(Blocks.STONE).save(consumer);
        EntropyRecipeBuilder.heat(AppEng.makeId("entropy/heat/ice_water")).setInputBlock(Blocks.ICE).setOutputFluid((Fluid)Fluids.WATER).save(consumer);
        EntropyRecipeBuilder.heat(AppEng.makeId("entropy/heat/snow_water")).setInputBlock(Blocks.SNOW).setOutputFluid((Fluid)Fluids.FLOWING_WATER).save(consumer);
        EntropyRecipeBuilder.heat(AppEng.makeId("entropy/heat/water_air")).setInputFluid((Fluid)Fluids.WATER).setOutputBlock(Blocks.AIR).save(consumer);
    }

    public String getName() {
        return "AE2 Entropy Manipualator Recipes";
    }
}

