/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.loot;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.ConventionTags;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class BlockDropProvider
extends BlockLootSubProvider
implements IAE2DataProvider {
    private final Map<Block, Function<Block, LootTable.Builder>> overrides = this.createOverrides();
    private final Path outputFolder;

    @NotNull
    private ImmutableMap<Block, Function<Block, LootTable.Builder>> createOverrides() {
        return ImmutableMap.builder().put((Object)AEBlocks.MATRIX_FRAME.block(), $ -> LootTable.lootTable()).put((Object)AEBlocks.MYSTERIOUS_CUBE.block(), BlockDropProvider::mysteriousCube).put((Object)AEBlocks.FLAWLESS_BUDDING_QUARTZ.block(), this.flawlessBuddingQuartz()).put((Object)AEBlocks.FLAWED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.CHIPPED_BUDDING_QUARTZ)).put((Object)AEBlocks.CHIPPED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.DAMAGED_BUDDING_QUARTZ)).put((Object)AEBlocks.DAMAGED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.QUARTZ_BLOCK)).put((Object)AEBlocks.SMALL_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.MEDIUM_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.LARGE_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.QUARTZ_CLUSTER.block(), BlockDropProvider::quartzCluster).build();
    }

    public BlockDropProvider(PackOutput output) {
        super(Set.of(), FeatureFlagSet.of());
        this.outputFolder = output.getOutputFolder();
    }

    public void generate() {
    }

    public void generate(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
        super.generate(biConsumer);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            if (!((ResourceKey)entry.getKey()).location().getNamespace().equals("ae2")) continue;
            LootTable.Builder builder = this.overrides.getOrDefault(entry.getValue(), this::defaultBuilder).apply((Block)entry.getValue());
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)this.toJson(builder), (Path)this.getPath(this.outputFolder, ((ResourceKey)entry.getKey()).location())));
        }
        futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)this.toJson(LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(AEBlocks.SKY_STONE_BLOCK)))), (Path)this.getPath(this.outputFolder, AppEng.makeId("chests/meteorite"))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private LootTable.Builder defaultBuilder(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)block);
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry).when(ExplosionCondition.survivesExplosion());
        return LootTable.lootTable().withPool(pool);
    }

    private Function<Block, LootTable.Builder> flawlessBuddingQuartz() {
        return b -> this.createSingleItemTable((ItemLike)AEBlocks.FLAWED_BUDDING_QUARTZ.block());
    }

    private Function<Block, LootTable.Builder> buddingQuartz(BlockDefinition<?> degradedVersion) {
        return b -> this.createSingleItemTableWithSilkTouch((Block)b, degradedVersion);
    }

    private LootTable.Builder quartzBud(Block bud) {
        return this.createSingleItemTableWithSilkTouch(bud, AEItems.CERTUS_QUARTZ_DUST);
    }

    private static LootTable.Builder quartzCluster(Block cluster) {
        return BlockDropProvider.createSilkTouchDispatchTable((Block)cluster, (LootPoolEntryContainer.Builder)LootItem.lootTableItem(AEItems.CERTUS_QUARTZ_CRYSTAL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()));
    }

    private static LootTable.Builder mysteriousCube(Block block) {
        return BlockDropProvider.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)TagEntry.tagContents(ConventionTags.INSCRIBER_PRESSES).when(ExplosionCondition.survivesExplosion()));
    }

    private Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.getNamespace() + "/loot_tables/blocks/" + id.getPath() + ".json");
    }

    public JsonElement toJson(LootTable.Builder builder) {
        return LootDataType.TABLE.parser().toJsonTree((Object)this.finishBuilding(builder));
    }

    public LootTable finishBuilding(LootTable.Builder builder) {
        return builder.setParamSet(LootContextParamSets.BLOCK).build();
    }

    public String getName() {
        return "Applied Energistics 2 Block Drops";
    }
}

