/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.advancements;

import appeng.api.util.AEColor;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.stats.AdvancementTriggers;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.localization.LocalizationProvider;
import appeng.datagen.providers.tags.ConventionTags;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AdvancementGenerator
implements IAE2DataProvider {
    private final PackOutput output;
    private final LocalizationProvider localization;

    public AdvancementGenerator(PackOutput output, LocalizationProvider localization) {
        this.output = output;
        this.localization = localization;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path path = this.output.getOutputFolder();
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.getId())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.getId());
            }
            Path path1 = AdvancementGenerator.createPath(path, advancement);
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)advancement.deconstruct().serializeToJson(), (Path)path1));
        };
        this.generateAdvancements(consumer);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private void generateAdvancements(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.advancement().display(AEItems.CERTUS_QUARTZ_CRYSTAL, this.localization.component("achievement.ae2.Root", "Applied Energistics"), this.localization.component("achievement.ae2.Root.desc", "When a chest is simply not enough. Acquire Copper to start your AE2 adventure."), AppEng.makeId("textures/block/sky_stone_brick.png"), FrameType.TASK, false, false, false).addCriterion("copper", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COPPER_INGOT})).save(consumer, "ae2:main/root");
        Advancement charger = Advancement.Builder.advancement().display(AEBlocks.CHARGER, this.localization.component("achievement.ae2.Charger", "It's Chargin' Time !"), this.localization.component("achievement.ae2.Charger.desc", "Craft a Charger"), null, FrameType.TASK, true, true, false).parent(root).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.CHARGER})).save(consumer, "ae2:main/charger");
        Advancement compass = Advancement.Builder.advancement().display(AEItems.METEORITE_COMPASS, this.localization.component("achievement.ae2.Compass", "Meteorite Hunter"), this.localization.component("achievement.ae2.Compass.desc", "Craft a Meteorite Compass"), null, FrameType.TASK, true, true, false).parent(charger).addCriterion("compass", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.METEORITE_COMPASS})).save(consumer, "ae2:main/compass");
        Advancement chargedQuartz = Advancement.Builder.advancement().display(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, this.localization.component("achievement.ae2.ChargedQuartz", "Shocking"), this.localization.component("achievement.ae2.ChargedQuartz.desc", "Charge Quartz with a Charger"), null, FrameType.TASK, true, true, false).parent(charger).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED})).save(consumer, "ae2:main/charged_quartz");
        Advancement.Builder pressesBuilder = Advancement.Builder.advancement().display(AEItems.LOGIC_PROCESSOR_PRESS, this.localization.component("achievement.ae2.Presses", "Unknown Technology"), this.localization.component("achievement.ae2.Presses.desc", "Find all Processor Presses"), null, FrameType.TASK, true, true, false).parent(root).addCriterion("calculation", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.CALCULATION_PROCESSOR_PRESS})).addCriterion("engineering", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.ENGINEERING_PROCESSOR_PRESS})).addCriterion("logic", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.LOGIC_PROCESSOR_PRESS})).addCriterion("silicon", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.SILICON_PRESS}));
        Advancement presses = pressesBuilder.save(consumer, "ae2:main/presses");
        Advancement controller = Advancement.Builder.advancement().display(AEBlocks.CONTROLLER, this.localization.component("achievement.ae2.Controller", "Networking Switchboard"), this.localization.component("achievement.ae2.Controller.desc", "Craft a Controller"), null, FrameType.TASK, true, true, false).parent(presses).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.CONTROLLER})).save(consumer, "ae2:main/controller");
        Advancement storageCell = Advancement.Builder.advancement().display(AEItems.ITEM_CELL_64K, this.localization.component("achievement.ae2.StorageCell", "Better Than Chests"), this.localization.component("achievement.ae2.StorageCell.desc", "Craft a Storage Cell"), null, FrameType.TASK, false, false, false).parent(controller).addCriterion("c1k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_1K})).addCriterion("c4k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_4K})).addCriterion("c16k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_16K})).addCriterion("c64k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_64K})).addCriterion("c256k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_256K})).requirements(RequirementsStrategy.OR).save(consumer, "ae2:main/storage_cell");
        Advancement ioport = Advancement.Builder.advancement().display(AEBlocks.IO_PORT, this.localization.component("achievement.ae2.IOPort", "Storage Cell Shuffle"), this.localization.component("achievement.ae2.IOPort.desc", "Craft an IO Port"), null, FrameType.TASK, true, true, false).parent(storageCell).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.IO_PORT})).save(consumer, "ae2:main/ioport");
        Advancement craftingTerminal = Advancement.Builder.advancement().display(AEParts.CRAFTING_TERMINAL, this.localization.component("achievement.ae2.CraftingTerminal", "A (Much) Bigger Table"), this.localization.component("achievement.ae2.CraftingTerminal.desc", "Craft a Crafting Terminal"), null, FrameType.TASK, true, true, false).parent(controller).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEParts.CRAFTING_TERMINAL})).save(consumer, "ae2:main/crafting_terminal");
        Advancement patternTerminal = Advancement.Builder.advancement().display(AEParts.PATTERN_ENCODING_TERMINAL, this.localization.component("achievement.ae2.PatternTerminal", "Crafting Maestro"), this.localization.component("achievement.ae2.PatternTerminal.desc", "Craft a Pattern Encoding Terminal"), null, FrameType.TASK, true, true, false).parent(craftingTerminal).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEParts.PATTERN_ENCODING_TERMINAL})).save(consumer, "ae2:main/pattern_encoding_terminal");
        Advancement craftingCpu = Advancement.Builder.advancement().display(AEBlocks.CRAFTING_STORAGE_64K, this.localization.component("achievement.ae2.CraftingCPU", "Next Gen Crafting"), this.localization.component("achievement.ae2.CraftingCPU.desc", "Craft a Crafting Unit"), null, FrameType.TASK, false, false, false).parent(patternTerminal).addCriterion("cu", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.CRAFTING_UNIT})).requirements(RequirementsStrategy.OR).save(consumer, "ae2:main/crafting_cpu");
        Advancement fluix = Advancement.Builder.advancement().display(AEItems.FLUIX_CRYSTAL, this.localization.component("achievement.ae2.Fluix", "Unnatural"), this.localization.component("achievement.ae2.Fluix.desc", "Create Fluix Crystals"), null, FrameType.TASK, true, true, false).parent(chargedQuartz).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.FLUIX_CRYSTAL})).save(consumer, "ae2:main/fluix");
        Advancement glassCable = Advancement.Builder.advancement().display(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.GlassCable", "Fluix Energy Connection"), this.localization.component("achievement.ae2.GlassCable.desc", "Craft ME Glass Cable"), null, FrameType.TASK, true, true, false).parent(fluix).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(ConventionTags.GLASS_CABLE).build()})).save(consumer, "ae2:main/glass_cable");
        Advancement facade = Advancement.Builder.advancement().display(AEItems.FACADE.asItem().createFacadeForItemUnchecked(new ItemStack((ItemLike)Items.STONE)), this.localization.component("achievement.ae2.Facade", "Network Aesthetics"), this.localization.component("achievement.ae2.Facade.desc", "Craft a Cable Facade"), null, FrameType.TASK, true, true, false).parent(glassCable).addCriterion("facade", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.FACADE})).save(consumer, "ae2:main/facade");
        Advancement growthAccelerator = Advancement.Builder.advancement().display(AEBlocks.GROWTH_ACCELERATOR, this.localization.component("achievement.ae2.CrystalGrowthAccelerator", "Accelerator is an understatement"), this.localization.component("achievement.ae2.CrystalGrowthAccelerator.desc", "Craft a Crystal Growth Accelerator"), null, FrameType.TASK, true, true, false).parent(fluix).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.GROWTH_ACCELERATOR})).save(consumer, "ae2:main/growth_accelerator");
        Advancement network1 = Advancement.Builder.advancement().display(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking1", "Network Apprentice"), this.localization.component("achievement.ae2.Networking1.desc", "Reach 8 channels using devices on a network."), null, FrameType.TASK, true, true, false).parent(glassCable).addCriterion("cable", (CriterionTriggerInstance)AdvancementTriggers.NETWORK_APPRENTICE.instance()).save(consumer, "ae2:main/network1");
        Advancement network2 = Advancement.Builder.advancement().display(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking2", "Network Engineer"), this.localization.component("achievement.ae2.Networking2.desc", "Reach 128 channels using devices on a network."), null, FrameType.TASK, true, true, false).parent(network1).addCriterion("cable", (CriterionTriggerInstance)AdvancementTriggers.NETWORK_ENGINEER.instance()).save(consumer, "ae2:main/network2");
        Advancement network3 = Advancement.Builder.advancement().display(AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking3", "Network Administrator"), this.localization.component("achievement.ae2.Networking3.desc", "Reach 2048 channels using devices on a network."), null, FrameType.TASK, true, true, false).parent(network2).addCriterion("cable", (CriterionTriggerInstance)AdvancementTriggers.NETWORK_ADMIN.instance()).save(consumer, "ae2:main/network3");
        Advancement networkTool = Advancement.Builder.advancement().display(AEItems.NETWORK_TOOL, this.localization.component("achievement.ae2.NetworkTool", "Network Diagnostics"), this.localization.component("achievement.ae2.NetworkTool.desc", "Craft a Network Tool"), null, FrameType.TASK, true, true, false).parent(controller).addCriterion("network_tool", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.NETWORK_TOOL})).save(consumer, "ae2:main/network_tool");
        Advancement p2p = Advancement.Builder.advancement().display(AEParts.ME_P2P_TUNNEL, this.localization.component("achievement.ae2.P2P", "Point to Point Networking"), this.localization.component("achievement.ae2.P2P.desc", "Craft a P2P Tunnel"), null, FrameType.TASK, true, true, false).parent(glassCable).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEParts.ME_P2P_TUNNEL})).save(consumer, "ae2:main/p2p");
        Advancement portableCell = Advancement.Builder.advancement().display(AEItems.PORTABLE_ITEM_CELL1K, this.localization.component("achievement.ae2.PortableCell", "Storage Nomad"), this.localization.component("achievement.ae2.PortableCell.desc", "Craft a Portable Cell"), null, FrameType.TASK, false, false, false).parent(storageCell).addCriterion("pc_1k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL1K})).addCriterion("pc_4k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL4K})).addCriterion("pc_16k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL16K})).addCriterion("pc_64k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL64K})).addCriterion("pc_256k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL256K})).requirements(RequirementsStrategy.OR).save(consumer, "ae2:main/portable_cell");
        Advancement qnb = Advancement.Builder.advancement().display(AEBlocks.QUANTUM_LINK, this.localization.component("achievement.ae2.QNB", "Quantum Tunneling"), this.localization.component("achievement.ae2.QNB.desc", "Craft a Quantum Link"), null, FrameType.TASK, true, true, false).parent(p2p).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.QUANTUM_LINK})).save(consumer, "ae2:main/qnb");
        Advancement spatialIoport = Advancement.Builder.advancement().display(AEBlocks.SPATIAL_IO_PORT, this.localization.component("achievement.ae2.SpatialIO", "Spatial Coordination"), this.localization.component("achievement.ae2.SpatialIO.desc", "Craft a Spatial IO Port"), null, FrameType.TASK, true, true, false).parent(ioport).addCriterion("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEBlocks.SPATIAL_IO_PORT})).save(consumer, "ae2:main/spatial_ioport");
        Advancement spatialExplorer = Advancement.Builder.advancement().display(AEItems.SPATIAL_128_CELL_COMPONENT, this.localization.component("achievement.ae2.SpatialIOExplorer", "To boldly go"), this.localization.component("achievement.ae2.SpatialIOExplorer.desc", "Get stored in a spatial storage cell"), null, FrameType.TASK, false, false, false).parent(spatialIoport).addCriterion("explorer", (CriterionTriggerInstance)AdvancementTriggers.SPATIAL_EXPLORER.instance()).save(consumer, "ae2:main/spatial_explorer");
        Advancement storageBus = Advancement.Builder.advancement().display(AEParts.STORAGE_BUS, this.localization.component("achievement.ae2.StorageBus", "Limitless Potential"), this.localization.component("achievement.ae2.StorageBus.desc", "Craft a Storage Bus"), null, FrameType.TASK, true, true, false).parent(glassCable).addCriterion("part", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{AEParts.STORAGE_BUS})).save(consumer, "ae2:main/storage_bus");
        Advancement storageBusOnInterface = Advancement.Builder.advancement().display(AEBlocks.INTERFACE, this.localization.component("achievement.ae2.Recursive", "Recursive Networking"), this.localization.component("achievement.ae2.Recursive.desc", "Place a Storage Bus on an Interface."), null, FrameType.TASK, true, true, false).parent(storageBus).addCriterion("recursive", (CriterionTriggerInstance)AdvancementTriggers.RECURSIVE.instance()).save(consumer, "ae2:main/recursive");
    }

    private static Path createPath(Path basePath, Advancement advancement) {
        return basePath.resolve("data/" + advancement.getId().getNamespace() + "/advancements/" + advancement.getId().getPath() + ".json");
    }

    public String getName() {
        return "Advancements";
    }
}

