/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen;

import appeng.core.definitions.AEDamageTypes;
import appeng.datagen.providers.WorldGenProvider;
import appeng.datagen.providers.advancements.AdvancementGenerator;
import appeng.datagen.providers.localization.LocalizationProvider;
import appeng.datagen.providers.loot.BlockDropProvider;
import appeng.datagen.providers.models.BlockModelProvider;
import appeng.datagen.providers.models.CableModelProvider;
import appeng.datagen.providers.models.DecorationModelProvider;
import appeng.datagen.providers.models.ItemModelProvider;
import appeng.datagen.providers.models.PartModelProvider;
import appeng.datagen.providers.recipes.ChargerRecipes;
import appeng.datagen.providers.recipes.CraftingRecipes;
import appeng.datagen.providers.recipes.DecorationBlockRecipes;
import appeng.datagen.providers.recipes.DecorationRecipes;
import appeng.datagen.providers.recipes.EntropyRecipes;
import appeng.datagen.providers.recipes.InscriberRecipes;
import appeng.datagen.providers.recipes.MatterCannonAmmoProvider;
import appeng.datagen.providers.recipes.SmeltingRecipes;
import appeng.datagen.providers.recipes.SmithingRecipes;
import appeng.datagen.providers.recipes.TransformRecipes;
import appeng.datagen.providers.tags.BiomeTagsProvider;
import appeng.datagen.providers.tags.BlockTagsProvider;
import appeng.datagen.providers.tags.FluidTagsProvider;
import appeng.datagen.providers.tags.ItemTagsProvider;
import appeng.datagen.providers.tags.PoiTypeTagsProvider;
import appeng.init.worldgen.InitBiomes;
import appeng.init.worldgen.InitDimensionTypes;
import appeng.init.worldgen.InitStructures;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ae2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AE2DataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent dataEvent) {
        AE2DataGenerators.onGatherData(dataEvent.getGenerator(), dataEvent.getExistingFileHelper());
    }

    public static void onGatherData(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        AE2DataGenerators.onGatherData(generator, existingFileHelper, generator.getVanillaPack(true));
    }

    public static void onGatherData(DataGenerator generator, ExistingFileHelper existingFileHelper, DataGenerator.PackGenerator pack) {
        RegistryAccess.Frozen registryAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        CompletableFuture<HolderLookup.Provider> registries = AE2DataGenerators.createAppEngProvider((RegistryAccess)registryAccess);
        LocalizationProvider localization = new LocalizationProvider(generator);
        pack.addProvider(AE2DataGenerators.bindRegistries(WorldGenProvider::new, registries));
        pack.addProvider(BlockDropProvider::new);
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)pack.addProvider(packOutput -> new BlockTagsProvider(packOutput, registries, existingFileHelper));
        pack.addProvider(packOutput -> new ItemTagsProvider(packOutput, registries, blockTagsProvider.contentsGetter(), existingFileHelper));
        pack.addProvider(packOutput -> new FluidTagsProvider(packOutput, registries, existingFileHelper));
        pack.addProvider(packOutput -> new BiomeTagsProvider(packOutput, registries, existingFileHelper));
        pack.addProvider(packOutput -> new PoiTypeTagsProvider(packOutput, registries, existingFileHelper));
        pack.addProvider(packOutput -> new BlockModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new DecorationModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new ItemModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new CableModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new PartModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new AdvancementGenerator(packOutput, localization));
        pack.addProvider(DecorationRecipes::new);
        pack.addProvider(DecorationBlockRecipes::new);
        pack.addProvider(MatterCannonAmmoProvider::new);
        pack.addProvider(EntropyRecipes::new);
        pack.addProvider(InscriberRecipes::new);
        pack.addProvider(SmeltingRecipes::new);
        pack.addProvider(CraftingRecipes::new);
        pack.addProvider(SmithingRecipes::new);
        pack.addProvider(TransformRecipes::new);
        pack.addProvider(ChargerRecipes::new);
        pack.addProvider(packOutput -> localization);
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> factory, CompletableFuture<HolderLookup.Provider> factories) {
        return packOutput -> (DataProvider)factory.apply(packOutput, factories);
    }

    private static CompletableFuture<HolderLookup.Provider> createAppEngProvider(RegistryAccess registryAccess) {
        CompletableFuture<HolderLookup.Provider> vanillaLookup = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        return vanillaLookup.thenApply(provider -> {
            RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.DIMENSION_TYPE, InitDimensionTypes::init).add(Registries.STRUCTURE, InitStructures::initDatagenStructures).add(Registries.STRUCTURE_SET, InitStructures::initDatagenStructureSets).add(Registries.BIOME, InitBiomes::init).add(Registries.DAMAGE_TYPE, AEDamageTypes::init);
            return builder.buildPatch(registryAccess, provider);
        });
    }
}

