/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.core.AELog;
import appeng.crafting.pattern.AEStonecuttingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.StonecuttingPatternEncoding;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StonecuttingPatternItem
extends EncodedPatternItem {
    public StonecuttingPatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AEStonecuttingPattern decode(ItemStack stack, Level level, boolean tryRecovery) {
        CompoundTag tag;
        if (stack.getItem() != this || !stack.hasTag() || level == null) {
            return null;
        }
        AEStonecuttingPattern result = this.decode(AEItemKey.of(stack), level);
        if (tryRecovery && result == null && this.attemptRecovery(tag = stack.getOrCreateTag(), level)) {
            result = this.decode(stack, level, false);
        }
        return result;
    }

    @Override
    public AEStonecuttingPattern decode(AEItemKey what, Level level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AEStonecuttingPattern(what, level);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack encode(StonecutterRecipe recipe, AEItemKey in, AEItemKey out, boolean allowSubstitutes) {
        ItemStack stack = new ItemStack((ItemLike)this);
        StonecuttingPatternEncoding.encode(stack.getOrCreateTag(), recipe, in, out, allowSubstitutes);
        return stack;
    }

    private boolean attemptRecovery(CompoundTag tag, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        AEItemKey input = StonecuttingPatternEncoding.getInput(tag);
        AEItemKey output = StonecuttingPatternEncoding.getOutput(tag);
        if (input == null || output == null) {
            return false;
        }
        ResourceLocation recipeId = StonecuttingPatternEncoding.getRecipeId(tag);
        SimpleContainer testInventory = new SimpleContainer(1);
        testInventory.setItem(0, input.toStack());
        List potentialRecipes = recipeManager.getRecipesFor(RecipeType.STONECUTTING, (Container)testInventory, level);
        for (StonecutterRecipe potentialRecipe : potentialRecipes) {
            if (!AEItemKey.matches(output, potentialRecipe.getResultItem(level.registryAccess()))) continue;
            AELog.debug("Re-Encoding pattern from %s -> %s", recipeId, potentialRecipe.getId());
            StonecuttingPatternEncoding.encode(tag, potentialRecipe, input, output, StonecuttingPatternEncoding.canSubstitute(tag));
        }
        AELog.info("Failed to recover encoded stonecutting pattern for recipe %s", recipeId);
        return false;
    }
}

