/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.StonecutterRecipe;

class StonecuttingPatternEncoding {
    private static final String NBT_INPUT = "in";
    private static final String NBT_OUTPUT = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_RECIPE_ID = "recipe";

    StonecuttingPatternEncoding() {
    }

    public static AEItemKey getInput(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have an in tag.");
        return AEItemKey.fromTag(nbt.getCompound(NBT_INPUT));
    }

    public static AEItemKey getOutput(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have an out tag.");
        return AEItemKey.fromTag(nbt.getCompound(NBT_OUTPUT));
    }

    public static boolean canSubstitute(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.getBoolean(NBT_SUBSITUTE);
    }

    public static ResourceLocation getRecipeId(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new ResourceLocation(nbt.getString(NBT_RECIPE_ID));
    }

    public static void encode(CompoundTag tag, StonecutterRecipe recipe, AEItemKey input, AEItemKey output, boolean allowSubstitution) {
        tag.put(NBT_INPUT, (Tag)input.toTag());
        tag.put(NBT_OUTPUT, (Tag)output.toTag());
        tag.putBoolean(NBT_SUBSITUTE, allowSubstitution);
        tag.putString(NBT_RECIPE_ID, recipe.getId().toString());
    }
}

