/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.SmithingRecipe;

class SmithingTablePatternEncoding {
    private static final String NBT_TEMPLATE = "template";
    private static final String NBT_BASE = "base";
    private static final String NBT_ADDITION = "addition";
    private static final String NBT_OUTPUT = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_RECIPE_ID = "recipe";

    SmithingTablePatternEncoding() {
    }

    public static AEItemKey getTemplate(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a template tag.");
        return AEItemKey.fromTag(nbt.getCompound(NBT_TEMPLATE));
    }

    public static AEItemKey getBase(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a base tag.");
        return AEItemKey.fromTag(nbt.getCompound(NBT_BASE));
    }

    public static AEItemKey getAddition(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have an addition tag.");
        return AEItemKey.fromTag(nbt.getCompound(NBT_ADDITION));
    }

    public static AEItemKey getOutput(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have an out tag.");
        return AEItemKey.fromTag(nbt.getCompound(NBT_OUTPUT));
    }

    public static boolean canSubstitute(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.getBoolean(NBT_SUBSITUTE);
    }

    public static ResourceLocation getRecipeId(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new ResourceLocation(nbt.getString(NBT_RECIPE_ID));
    }

    public static void encode(CompoundTag tag, SmithingRecipe recipe, AEItemKey template, AEItemKey base, AEItemKey addition, AEItemKey output, boolean allowSubstitution) {
        tag.put(NBT_TEMPLATE, (Tag)template.toTag());
        tag.put(NBT_BASE, (Tag)base.toTag());
        tag.put(NBT_ADDITION, (Tag)addition.toTag());
        tag.put(NBT_OUTPUT, (Tag)output.toTag());
        tag.putBoolean(NBT_SUBSITUTE, allowSubstitution);
        tag.putString(NBT_RECIPE_ID, recipe.getId().toString());
    }
}

