/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

class InvalidPatternHelper {
    private final List<PatternIngredient> outputs = new ArrayList<PatternIngredient>();
    private final List<PatternIngredient> inputs = new ArrayList<PatternIngredient>();
    private final boolean isCrafting;
    private final boolean canSubstitute;

    public InvalidPatternHelper(ItemStack is) {
        int i;
        CompoundTag encodedValue = is.getTag();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        ListTag inTag = encodedValue.getList("in", 10);
        ListTag outTag = encodedValue.getList("out", 10);
        this.isCrafting = encodedValue.getBoolean("crafting");
        this.canSubstitute = this.isCrafting && encodedValue.getBoolean("substitute");
        for (i = 0; i < outTag.size(); ++i) {
            this.outputs.add(new PatternIngredient(outTag.getCompound(i)));
        }
        for (i = 0; i < inTag.size(); ++i) {
            CompoundTag in = inTag.getCompound(i);
            if (in.isEmpty()) continue;
            this.inputs.add(new PatternIngredient(in));
        }
    }

    public List<PatternIngredient> getOutputs() {
        return this.outputs;
    }

    public List<PatternIngredient> getInputs() {
        return this.inputs;
    }

    public boolean isCraftable() {
        return this.isCrafting;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public static class PatternIngredient {
        private String id;
        private int count;
        private int damage;
        private ItemStack stack;

        public PatternIngredient(CompoundTag tag) {
            this.stack = ItemStack.of((CompoundTag)tag);
            if (this.stack.isEmpty()) {
                this.id = tag.getString("id");
                this.count = tag.getByte("Count");
                this.damage = Math.max(0, tag.getShort("Damage"));
            }
        }

        public boolean isValid() {
            return !this.stack.isEmpty();
        }

        public Component getName() {
            return this.isValid() ? this.stack.getHoverName() : Component.literal((String)(this.id + "@" + this.getDamage()));
        }

        public int getDamage() {
            return this.isValid() ? this.stack.getDamageValue() : this.damage;
        }

        public int getCount() {
            return this.isValid() ? this.stack.getCount() : this.count;
        }

        public ItemStack getItem() {
            if (!this.isValid()) {
                throw new IllegalArgumentException("There is no valid ItemStack for this PatternIngredient");
            }
            return this.stack;
        }

        public Component getFormattedToolTip() {
            MutableComponent result = Component.literal((String)(this.getCount() + " ")).append(this.getName());
            if (!this.isValid()) {
                result.withStyle(ChatFormatting.RED);
            }
            return result;
        }
    }
}

