/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.InvalidPatternHelper;
import appeng.items.AEBaseItem;
import appeng.items.misc.WrappedGenericStack;
import appeng.util.InteractionUtil;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class EncodedPatternItem
extends AEBaseItem {
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new WeakHashMap<ItemStack, ItemStack>();

    public EncodedPatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.clearPattern(player.getItemInHand(hand), player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.clearPattern(stack, context.getPlayer()) ? InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) : InteractionResult.PASS;
    }

    private boolean clearPattern(ItemStack stack, Player player) {
        if (InteractionUtil.isInAlternateUseMode(player)) {
            if (player.getCommandSenderWorld().isClientSide()) {
                return false;
            }
            Inventory inv = player.getInventory();
            ItemStack is = AEItems.BLANK_PATTERN.stack(stack.getCount());
            if (!is.isEmpty()) {
                for (int s = 0; s < player.getInventory().getContainerSize(); ++s) {
                    if (inv.getItem(s) != stack) continue;
                    inv.setItem(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        boolean isCrafting;
        if (!stack.hasTag()) {
            return;
        }
        IPatternDetails details = this.decode(stack, level, false);
        if (details == null) {
            stack.setHoverName((Component)GuiText.InvalidPattern.text().copy().withStyle(ChatFormatting.RED));
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            MutableComponent label = (invalid.isCraftable() ? GuiText.Crafts.text() : GuiText.Produces.text()).copy().append(": ");
            MutableComponent and = Component.literal((String)" ").append((Component)GuiText.And.text().withStyle(ChatFormatting.GRAY)).append(" ");
            MutableComponent with = Component.empty().append((Component)GuiText.With.text().append(": ").withStyle(ChatFormatting.GRAY));
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                lines.add((Component)Component.empty().append((Component)(first ? label : and)).append(output.getFormattedToolTip()));
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                lines.add((Component)(first ? with : and).copy().append(input.getFormattedToolTip()));
                first = false;
            }
            if (invalid.isCraftable()) {
                MutableComponent substitutionLabel = GuiText.Substitute.text().copy().append(" ");
                MutableComponent canSubstitute = invalid.canSubstitute() ? GuiText.Yes.text() : GuiText.No.text();
                lines.add((Component)substitutionLabel.copy().append((Component)canSubstitute));
            }
            return;
        }
        if (stack.hasCustomHoverName()) {
            stack.resetHoverName();
        }
        boolean substitute = (isCrafting = details instanceof AECraftingPattern) && ((AECraftingPattern)details).canSubstitute;
        IPatternDetails.IInput[] in = details.getInputs();
        GenericStack[] out = details.getOutputs();
        MutableComponent label = (isCrafting ? GuiText.Crafts.text() : GuiText.Produces.text()).copy().append(": ").withStyle(ChatFormatting.GRAY);
        MutableComponent and = Component.literal((String)" ").copy().append((Component)GuiText.And.text()).append(" ").withStyle(ChatFormatting.GRAY);
        MutableComponent with = GuiText.With.text().copy().append(": ").withStyle(ChatFormatting.GRAY);
        boolean first = true;
        for (GenericStack anOut : out) {
            if (anOut == null) continue;
            lines.add((Component)Component.empty().append((Component)(first ? label : and)).append(EncodedPatternItem.getStackComponent(anOut)));
            first = false;
        }
        first = true;
        for (IPatternDetails.IInput anIn : in) {
            if (anIn == null) continue;
            GenericStack primaryInputTemplate = anIn.getPossibleInputs()[0];
            GenericStack primaryInput = new GenericStack(primaryInputTemplate.what(), primaryInputTemplate.amount() * anIn.getMultiplier());
            lines.add((Component)Component.empty().append((Component)(first ? with : and)).append(EncodedPatternItem.getStackComponent(primaryInput)));
            first = false;
        }
        if (isCrafting) {
            MutableComponent substitutionLabel = GuiText.Substitute.text().copy().append(" ");
            MutableComponent canSubstitute = substitute ? GuiText.Yes.text() : GuiText.No.text();
            lines.add((Component)substitutionLabel.copy().append((Component)canSubstitute));
        }
    }

    protected static Component getStackComponent(GenericStack stack) {
        String amountInfo = stack.what().formatAmount(stack.amount(), AmountFormat.FULL);
        Component displayName = stack.what().getDisplayName();
        return Component.literal((String)(amountInfo + " x ")).append(displayName);
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        Level level = AppEng.instance().getClientLevel();
        if (level == null) {
            return ItemStack.EMPTY;
        }
        IPatternDetails details = this.decode(item, level, false);
        out = ItemStack.EMPTY;
        if (details != null) {
            GenericStack output = details.getPrimaryOutput();
            AEKey aEKey = output.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                out = itemKey.toStack();
            } else {
                out = WrappedGenericStack.wrap(output.what(), 0L);
            }
        }
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    @Nullable
    public abstract IPatternDetails decode(ItemStack var1, Level var2, boolean var3);

    @Nullable
    public abstract IPatternDetails decode(AEItemKey var1, Level var2);
}

