/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.CraftingPatternEncoding;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.AutoCraftingMenu;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CraftingPatternItem
extends EncodedPatternItem {
    public CraftingPatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AECraftingPattern decode(ItemStack stack, Level level, boolean tryRecovery) {
        CompoundTag tag;
        if (stack.getItem() != this || !stack.hasTag() || level == null) {
            return null;
        }
        AECraftingPattern result = this.decode(AEItemKey.of(stack), level);
        if (tryRecovery && result == null && this.attemptRecovery(tag = stack.getOrCreateTag(), level)) {
            result = this.decode(stack, level, false);
        }
        return result;
    }

    @Override
    public AECraftingPattern decode(AEItemKey what, Level level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AECraftingPattern(what, level);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack encode(CraftingRecipe recipe, ItemStack[] in, ItemStack out, boolean allowSubstitutes, boolean allowFluidSubstitutes) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CraftingPatternEncoding.encodeCraftingPattern(stack.getOrCreateTag(), recipe, in, out, allowSubstitutes, allowFluidSubstitutes);
        return stack;
    }

    private boolean attemptRecovery(CompoundTag tag, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        GenericStack[] ingredients = CraftingPatternEncoding.getCraftingInputs(tag);
        ItemStack product = CraftingPatternEncoding.getCraftingResult(tag);
        if (product.isEmpty()) {
            return false;
        }
        ResourceLocation currentRecipeId = CraftingPatternEncoding.getRecipeId(tag);
        TransientCraftingContainer testInventory = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
        for (int x = 0; x < 9; ++x) {
            GenericStack ais = x < ingredients.length ? ingredients[x] : null;
            AEKey aEKey = ais.what();
            if (!(aEKey instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)aEKey;
            testInventory.setItem(x, itemKey.toStack());
        }
        CraftingRecipe potentialRecipe = recipeManager.getRecipeFor(RecipeType.CRAFTING, (Container)testInventory, level).orElse(null);
        if (potentialRecipe != null && ItemStack.isSameItemSameTags((ItemStack)product, (ItemStack)potentialRecipe.assemble((Container)testInventory, level.registryAccess()))) {
            AELog.debug("Re-Encoding pattern from %s -> %s", currentRecipeId, potentialRecipe.getId());
            ItemStack[] in = (ItemStack[])Arrays.stream(ingredients).map(stack -> {
                ItemStack itemStack;
                AEKey patt3596$temp = stack.what();
                if (patt3596$temp instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)patt3596$temp;
                    itemStack = itemKey.toStack();
                } else {
                    itemStack = ItemStack.EMPTY;
                }
                return itemStack;
            }).toArray(ItemStack[]::new);
            CraftingPatternEncoding.encodeCraftingPattern(tag, potentialRecipe, in, product, CraftingPatternEncoding.canSubstitute(tag), CraftingPatternEncoding.canSubstituteFluids(tag));
        }
        AELog.debug("Failed to recover encoded crafting pattern for recipe %s", currentRecipeId);
        return false;
    }
}

