/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;

class CraftingPatternEncoding {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_SUBSITUTE_FLUIDS = "substituteFluids";
    private static final String NBT_RECIPE_ID = "recipe";

    CraftingPatternEncoding() {
    }

    public static GenericStack[] getCraftingInputs(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        ListTag tag = nbt.getList(NBT_INPUTS, 10);
        Preconditions.checkArgument((tag.size() <= 9 ? 1 : 0) != 0, (Object)"Cannot use more than 9 ingredients");
        GenericStack[] result = new GenericStack[tag.size()];
        for (int x = 0; x < tag.size(); ++x) {
            CompoundTag ingredientTag = tag.getCompound(x);
            if (ingredientTag.isEmpty()) continue;
            result[x] = GenericStack.fromItemStack(ItemStack.of((CompoundTag)ingredientTag));
        }
        return result;
    }

    public static boolean canSubstitute(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.getBoolean(NBT_SUBSITUTE);
    }

    public static boolean canSubstituteFluids(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.getBoolean(NBT_SUBSITUTE_FLUIDS);
    }

    public static ResourceLocation getRecipeId(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new ResourceLocation(nbt.getString(NBT_RECIPE_ID));
    }

    public static ItemStack getCraftingResult(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return ItemStack.of((CompoundTag)nbt.getCompound(NBT_OUTPUTS));
    }

    public static void encodeCraftingPattern(CompoundTag tag, CraftingRecipe recipe, ItemStack[] sparseInputs, ItemStack output, boolean allowSubstitution, boolean allowFluidSubstitution) {
        tag.put(NBT_INPUTS, (Tag)CraftingPatternEncoding.encodeItemStackList(sparseInputs));
        tag.putBoolean(NBT_SUBSITUTE, allowSubstitution);
        tag.putBoolean(NBT_SUBSITUTE_FLUIDS, allowFluidSubstitution);
        tag.put(NBT_OUTPUTS, (Tag)output.save(new CompoundTag()));
        tag.putString(NBT_RECIPE_ID, recipe.getId().toString());
    }

    private static ListTag encodeItemStackList(ItemStack[] stacks) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) {
                tag.add((Object)new CompoundTag());
                continue;
            }
            tag.add((Object)stack.save(new CompoundTag()));
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }
}

