/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.crafting.pattern.StonecuttingPatternEncoding;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AEStonecuttingPattern
implements IPatternDetails,
IMolecularAssemblerSupportedPattern {
    private static final int CRAFTING_GRID_SLOT = 4;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    private final StonecutterRecipe recipe;
    private final Container testFrame;
    private final AEItemKey input;
    private final ItemStack output;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] outputs;
    private final Map<Item, Boolean> isValidCache = new IdentityHashMap<Item, Boolean>();

    public AEStonecuttingPattern(AEItemKey definition, Level level) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.input = StonecuttingPatternEncoding.getInput(tag);
        this.canSubstitute = StonecuttingPatternEncoding.canSubstitute(tag);
        ResourceLocation recipeId = StonecuttingPatternEncoding.getRecipeId(tag);
        this.recipe = (StonecutterRecipe)level.getRecipeManager().byType(RecipeType.STONECUTTING).get(recipeId);
        this.testFrame = new SimpleContainer(1);
        this.testFrame.setItem(0, this.input.toStack());
        if (!this.recipe.matches(this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + recipeId + " no longer matches the encoded input.");
        }
        this.output = this.recipe.assemble(this.testFrame, level.registryAccess());
        if (this.output.isEmpty()) {
            throw new IllegalStateException("The recipe " + recipeId + " produced an empty item stack result.");
        }
        this.inputs = new IPatternDetails.IInput[]{new Input()};
        this.outputs = new GenericStack[]{GenericStack.fromItemStack(this.output)};
    }

    public ResourceLocation getRecipeId() {
        return this.recipe.getId();
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AEStonecuttingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    private Ingredient getRecipeIngredient() {
        return (Ingredient)this.recipe.getIngredients().get(0);
    }

    public boolean isItemValid(AEItemKey key, Level level) {
        if (key == null) {
            return false;
        }
        if (!this.canSubstitute) {
            return this.input.equals(key);
        }
        Boolean result = this.getTestResult(key);
        if (result != null) {
            return result;
        }
        ItemStack previousStack = this.testFrame.removeItemNoUpdate(0);
        this.testFrame.setItem(0, key.toStack());
        boolean newResult = this.recipe.matches(this.testFrame, level) && ItemStack.matches((ItemStack)this.output, (ItemStack)this.recipe.assemble(this.testFrame, level.registryAccess()));
        this.setTestResult(key, newResult);
        this.testFrame.setItem(0, previousStack);
        return newResult;
    }

    @Nullable
    private Boolean getTestResult(AEItemKey what) {
        if (what == null || what.hasTag()) {
            return null;
        }
        return this.isValidCache.get(what.getItem());
    }

    private void setTestResult(AEItemKey what, boolean result) {
        if (what != null && !what.hasTag()) {
            this.isValidCache.put(what.getItem(), result);
        }
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public ItemStack assemble(Container container, Level level) {
        SimpleContainer testContainer = new SimpleContainer(2);
        testContainer.setItem(0, container.getItem(4));
        if (this.recipe.matches((Container)testContainer, level)) {
            return this.recipe.assemble((Container)testContainer, level.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isItemValid(int slot, AEItemKey key, Level level) {
        return slot == 4 && this.isItemValid(key, level);
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        return slot == 4;
    }

    @Override
    public void fillCraftingGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern.CraftingGridAccessor gridAccessor) {
        Object object;
        Object2LongMap.Entry<AEKey> entry = table[0].getFirstEntry();
        if (entry != null && (object = entry.getKey()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)object;
            gridAccessor.set(4, itemKey.toStack());
            table[0].remove((AEKey)entry.getKey(), 1L);
        }
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public AEItemKey getInput() {
        return this.input;
    }

    private class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] possibleInputs;

        private Input() {
            if (!AEStonecuttingPattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{new GenericStack(AEStonecuttingPattern.this.input, 1L)};
            } else {
                ItemStack[] matchingStacks = AEStonecuttingPattern.this.getRecipeIngredient().getItems();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = new GenericStack(AEStonecuttingPattern.this.input, 1L);
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return 1L;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AEStonecuttingPattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AEStonecuttingPattern.this.isItemValid(itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

