/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public abstract class AESavedData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void save(File file) {
        if (!this.isDirty()) {
            return;
        }
        File tempFile = file.toPath().getParent().resolve(file.getName() + ".temp").toFile();
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("data", (Tag)this.save(new CompoundTag()));
        NbtUtils.addCurrentDataVersion((CompoundTag)compoundTag);
        try {
            NbtIo.writeCompressed((CompoundTag)compoundTag, (File)tempFile);
            if (file.exists() && !file.delete()) {
                LOGGER.error("Could not delete old file {}", (Object)file);
            }
            if (!tempFile.renameTo(file)) {
                LOGGER.error("Could not rename file {} to {}", (Object)tempFile, (Object)file);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Could not save data {}", (Object)this, (Object)iOException);
        }
        this.setDirty(false);
    }
}

