/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.menu.AEBaseMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class SwapSlotsPacket
extends BasePacket {
    private final int slotA;
    private final int slotB;

    public SwapSlotsPacket(FriendlyByteBuf stream) {
        this.slotA = stream.readInt();
        this.slotB = stream.readInt();
    }

    public SwapSlotsPacket(int slotA, int slotB) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.slotA = slotA;
        data.writeInt(this.slotA);
        this.slotB = slotB;
        data.writeInt(this.slotB);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        if (player != null && player.containerMenu instanceof AEBaseMenu) {
            ((AEBaseMenu)player.containerMenu).swapSlotContents(this.slotA, this.slotB);
        }
    }
}

