/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.client.gui.me.patternaccess.PatternAccessTermScreen;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PatternAccessTerminalPacket
extends BasePacket {
    private boolean fullUpdate;
    private long inventoryId;
    private int inventorySize;
    private long sortBy;
    private PatternContainerGroup group;
    private Int2ObjectMap<ItemStack> slots;

    public PatternAccessTerminalPacket(FriendlyByteBuf stream) {
        this.inventoryId = stream.readVarLong();
        this.fullUpdate = stream.readBoolean();
        if (this.fullUpdate) {
            this.inventorySize = stream.readVarInt();
            this.sortBy = stream.readVarLong();
            this.group = PatternContainerGroup.readFromPacket(stream);
        }
        int slotsCount = stream.readVarInt();
        this.slots = new Int2ObjectArrayMap(slotsCount);
        for (int i = 0; i < slotsCount; ++i) {
            int slot = stream.readVarInt();
            ItemStack item = stream.readItem();
            this.slots.put(slot, (Object)item);
        }
    }

    private PatternAccessTerminalPacket(boolean fullUpdate, long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<ItemStack> slots) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer((int)2048));
        data.writeInt(this.getPacketID());
        data.writeVarLong(inventoryId);
        data.writeBoolean(fullUpdate);
        if (fullUpdate) {
            data.writeVarInt(inventorySize);
            data.writeVarLong(sortBy);
            group.writeToPacket(data);
        }
        data.writeVarInt(slots.size());
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            data.writeVarInt(entry.getIntKey());
            data.writeItem((ItemStack)entry.getValue());
        }
        this.configureWrite(data);
    }

    public static PatternAccessTerminalPacket fullUpdate(long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<ItemStack> slots) {
        return new PatternAccessTerminalPacket(true, inventoryId, inventorySize, sortBy, group, slots);
    }

    public static PatternAccessTerminalPacket incrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        return new PatternAccessTerminalPacket(false, inventoryId, 0, 0L, null, slots);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof PatternAccessTermScreen) {
            PatternAccessTermScreen patternAccessTerminal = (PatternAccessTermScreen)screen;
            if (this.fullUpdate) {
                patternAccessTerminal.postFullUpdate(this.inventoryId, this.sortBy, this.group, this.inventorySize, this.slots);
            } else {
                patternAccessTerminal.postIncrementalUpdate(this.inventoryId, this.slots);
            }
        }
    }
}

