/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class PartLeftClickPacket
extends BasePacket {
    private BlockHitResult hitResult;
    private boolean alternateUseMode;

    public PartLeftClickPacket(FriendlyByteBuf stream) {
        this.hitResult = stream.readBlockHitResult();
        this.alternateUseMode = stream.readBoolean();
    }

    public PartLeftClickPacket(BlockHitResult hitResult, boolean alternateUseMode) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBlockHitResult(hitResult);
        data.writeBoolean(alternateUseMode);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock((Player)player, this.hitResult.getBlockPos(), this.hitResult.getDirection());
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled() || evt.getResult() == Event.Result.DENY) {
            return;
        }
        Vec3 localPos = this.hitResult.getLocation().subtract((double)this.hitResult.getBlockPos().getX(), (double)this.hitResult.getBlockPos().getY(), (double)this.hitResult.getBlockPos().getZ());
        BlockEntity blockEntity = player.level().getBlockEntity(this.hitResult.getBlockPos());
        if (blockEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)blockEntity;
            SelectedPart selectedPart = partHost.selectPartLocal(localPos);
            if (selectedPart.part != null) {
                if (!this.alternateUseMode) {
                    selectedPart.part.onClicked((Player)player, localPos);
                } else {
                    selectedPart.part.onShiftClicked((Player)player, localPos);
                }
            }
        }
    }
}

