/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.helpers.InventoryAction;
import appeng.menu.me.common.IMEInteractionHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MEInteractionPacket
extends BasePacket {
    private final int containerId;
    private final long serial;
    private final InventoryAction action;

    public MEInteractionPacket(FriendlyByteBuf buffer) {
        this.containerId = buffer.readInt();
        this.serial = buffer.readVarLong();
        this.action = (InventoryAction)buffer.readEnum(InventoryAction.class);
    }

    public MEInteractionPacket(int containerId, long serial, InventoryAction action) {
        this.containerId = containerId;
        this.serial = serial;
        this.action = action;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(containerId);
        data.writeVarLong(serial);
        data.writeEnum((Enum)action);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IMEInteractionHandler) {
            IMEInteractionHandler handler = (IMEInteractionHandler)abstractContainerMenu;
            if (player.containerMenu.containerId != this.containerId) {
                return;
            }
            handler.handleInteraction(this.serial, this.action);
        }
    }
}

