/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.render.effects.EnergyParticleData;
import appeng.core.AppEngClient;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTransitionEffectPacket
extends BasePacket {
    private final double x;
    private final double y;
    private final double z;
    private final Direction d;

    public ItemTransitionEffectPacket(double x, double y, double z, Direction direction) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d = direction;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        data.writeByte(this.d.ordinal());
        this.configureWrite(data);
    }

    public ItemTransitionEffectPacket(FriendlyByteBuf stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
        this.d = Direction.values()[stream.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(Player player) {
        EnergyParticleData data = new EnergyParticleData(true, this.d);
        for (int zz = 0; zz < 8; ++zz) {
            if (!AppEngClient.instance().shouldAddParticles(player.getRandom())) continue;
            double x = this.x + (double)player.getRandom().nextFloat() * 0.5 - 0.25;
            double y = this.y + (double)player.getRandom().nextFloat() * 0.5 - 0.25;
            double z = this.z + (double)player.getRandom().nextFloat() * 0.5 - 0.25;
            double speedX = 0.1f * (float)this.d.getStepX();
            double speedY = 0.1f * (float)this.d.getStepY();
            double speedZ = 0.1f * (float)this.d.getStepZ();
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)data, x, y, z, speedX, speedY, speedZ);
        }
    }
}

