/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.features.HotkeyAction;
import appeng.client.Hotkey;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.BasePacket;
import appeng.hotkeys.HotkeyActions;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class HotkeyPacket
extends BasePacket {
    private final String hotkey;

    public HotkeyPacket(FriendlyByteBuf stream) {
        this.hotkey = stream.readUtf();
    }

    public HotkeyPacket(Hotkey hotkey) {
        this.hotkey = hotkey.name();
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeUtf(this.hotkey);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        List<HotkeyAction> actions = HotkeyActions.REGISTRY.get(this.hotkey);
        if (actions == null) {
            player.sendSystemMessage((Component)PlayerMessages.UnknownHotkey.text().copy().append((Component)Component.translatable((String)("key.ae2." + this.hotkey))));
            AELog.warn("Player %s tried using unknown hotkey \"%s\"", player, this.hotkey);
            return;
        }
        for (HotkeyAction action : actions) {
            if (action.run((Player)player)) break;
        }
    }
}

