/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.FuzzyMode;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.helpers.IMenuCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.util.CraftingRecipeUtil;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class FillCraftingGridFromRecipePacket
extends BasePacket {
    private ResourceLocation recipeId;
    private NonNullList<ItemStack> ingredientTemplates;
    private boolean craftMissing;

    public FillCraftingGridFromRecipePacket(FriendlyByteBuf stream) {
        this.recipeId = stream.readBoolean() ? stream.readResourceLocation() : null;
        this.ingredientTemplates = NonNullList.withSize((int)stream.readInt(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.ingredientTemplates.size(); ++i) {
            this.ingredientTemplates.set(i, (Object)stream.readItem());
        }
        this.craftMissing = stream.readBoolean();
    }

    public FillCraftingGridFromRecipePacket(@Nullable ResourceLocation recipeId, NonNullList<ItemStack> ingredientTemplates, boolean craftMissing) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (recipeId != null) {
            data.writeBoolean(true);
            data.writeResourceLocation(recipeId);
        } else {
            data.writeBoolean(false);
        }
        data.writeInt(ingredientTemplates.size());
        for (ItemStack stack : ingredientTemplates) {
            data.writeItem(stack);
        }
        data.writeBoolean(craftMissing);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu menu = player.containerMenu;
        if (!(menu instanceof IMenuCraftingPacket)) {
            return;
        }
        IMenuCraftingPacket cct = (IMenuCraftingPacket)menu;
        if (!cct.useRealItems()) {
            AELog.warn("Trying to use real items for crafting in a pattern encoding terminal", new Object[0]);
            return;
        }
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        IStorageService storageService = grid.getStorageService();
        IEnergyService energy = grid.getEnergyService();
        InternalInventory craftMatrix = cct.getCraftingMatrix();
        MEStorage storage = storageService.getInventory();
        KeyCounter cachedStorage = storageService.getCachedInventory();
        IPartitionList filter = ViewCellItem.createItemFilter(cct.getViewCells());
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        ICraftingService craftingService = grid.getCraftingService();
        LinkedHashMap toAutoCraft = new LinkedHashMap();
        boolean touchedGridStorage = false;
        for (int x = 0; x < craftMatrix.size(); ++x) {
            ItemStack currentItem = craftMatrix.getStackInSlot(x);
            Ingredient ingredient = (Ingredient)ingredients.get(x);
            if (!currentItem.isEmpty()) {
                if (ingredient.test(currentItem)) continue;
                AEItemKey in = AEItemKey.of(currentItem);
                long inserted = StorageHelper.poweredInsert(energy, storage, in, currentItem.getCount(), cct.getActionSource());
                if (inserted > 0L) {
                    touchedGridStorage = true;
                }
                if (inserted < (long)currentItem.getCount()) {
                    currentItem = currentItem.copy();
                    currentItem.shrink((int)inserted);
                } else {
                    currentItem = ItemStack.EMPTY;
                }
                player.getInventory().add(currentItem);
                craftMatrix.setItemDirect(x, currentItem.isEmpty() ? ItemStack.EMPTY : currentItem);
            }
            if (ingredient.isEmpty()) continue;
            if (currentItem.isEmpty()) {
                List<AEItemKey> request = this.findBestMatchingItemStack(ingredient, filter, cachedStorage);
                for (AEItemKey what : request) {
                    long extracted = StorageHelper.poweredExtraction(energy, storage, what, 1L, cct.getActionSource());
                    if (extracted <= 0L) continue;
                    touchedGridStorage = true;
                    currentItem = what.toStack(Ints.saturatedCast((long)extracted));
                    break;
                }
            }
            if (currentItem.isEmpty()) {
                currentItem = this.takeIngredientFromPlayer(cct, player, ingredient);
            }
            craftMatrix.setItemDirect(x, currentItem);
            if (!currentItem.isEmpty() || !this.craftMissing) continue;
            int slot = x;
            this.findCraftableKey(ingredient, craftingService).ifPresent(key -> toAutoCraft.computeIfAbsent(key, k -> new IntArrayList()).add(slot));
        }
        menu.slotsChanged(craftMatrix.toContainer());
        if (!toAutoCraft.isEmpty()) {
            if (touchedGridStorage) {
                storageService.invalidateCache();
            }
            List<IMenuCraftingPacket.AutoCraftEntry> stacks = toAutoCraft.entrySet().stream().map(e -> new IMenuCraftingPacket.AutoCraftEntry((AEItemKey)e.getKey(), (List)e.getValue())).toList();
            cct.startAutoCrafting(stacks);
        }
    }

    private ItemStack takeIngredientFromPlayer(IMenuCraftingPacket cct, ServerPlayer player, Ingredient ingredient) {
        Inventory playerInv = player.getInventory();
        for (int i = 0; i < playerInv.items.size(); ++i) {
            ItemStack result;
            ItemStack item;
            if (cct.isPlayerInventorySlotLocked(i) || !ingredient.test(item = playerInv.getItem(i)) || (result = item.split(1)).isEmpty()) continue;
            return result;
        }
        return ItemStack.EMPTY;
    }

    private NonNullList<Ingredient> getDesiredIngredients(Player player) {
        Recipe recipe;
        if (this.recipeId != null && (recipe = (Recipe)player.level().getRecipeManager().byKey(this.recipeId).orElse(null)) != null) {
            return CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        }
        NonNullList ingredients = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got %d ingredient templates from client, expected %d", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack template = (ItemStack)this.ingredientTemplates.get(i);
            if (template.isEmpty()) continue;
            ingredients.set(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{template}));
        }
        return ingredients;
    }

    private List<AEItemKey> findBestMatchingItemStack(Ingredient ingredient, IPartitionList filter, KeyCounter storage) {
        return Arrays.stream(ingredient.getItems()).map(AEItemKey::of).filter(r -> r != null && (filter == null || filter.isListed((AEKey)r))).flatMap(s -> storage.findFuzzy((AEKey)s, FuzzyMode.IGNORE_ALL).stream()).filter(e -> ((AEItemKey)e.getKey()).matches(ingredient)).sorted((a, b) -> Long.compare(b.getLongValue(), a.getLongValue())).map(e -> (AEItemKey)e.getKey()).toList();
    }

    private Optional<AEItemKey> findCraftableKey(Ingredient ingredient, ICraftingService craftingService) {
        return Arrays.stream(ingredient.getItems()).map(AEItemKey::of).map(s -> (AEItemKey)craftingService.getFuzzyCraftable((AEKey)s, key -> ((AEItemKey)key).matches(ingredient))).filter(Objects::nonNull).findAny();
    }
}

