/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.core.AEConfig;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class CraftingJobStatusPacket
extends BasePacket {
    private UUID jobId;
    private AEKey what;
    private long requestedAmount;
    private long remainingAmount;
    private Status status;

    public CraftingJobStatusPacket(FriendlyByteBuf stream) {
        this.jobId = stream.readUUID();
        this.status = (Status)stream.readEnum(Status.class);
        this.what = AEKey.readKey(stream);
        this.requestedAmount = stream.readLong();
        this.remainingAmount = stream.readLong();
    }

    public CraftingJobStatusPacket(UUID jobId, AEKey what, long requestedAmount, long remainingAmount, Status status) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeUUID(jobId);
        data.writeEnum((Enum)status);
        AEKey.writeKey(data, what);
        data.writeLong(requestedAmount);
        data.writeLong(remainingAmount);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(Player player) {
        if (this.status == Status.STARTED && AEConfig.instance().isPinAutoCraftedItems()) {
            PinnedKeys.pinKey(this.what, PinnedKeys.PinReason.CRAFTING);
        }
        PendingCraftingJobs.jobStatus(this.jobId, this.what, this.requestedAmount, this.remainingAmount, this.status);
    }

    public static enum Status {
        STARTED,
        CANCELLED,
        FINISHED;

    }
}

