/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEColor;
import appeng.core.sync.BasePacket;
import appeng.items.tools.powered.ColorApplicatorItem;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ColorApplicatorSelectColorPacket
extends BasePacket {
    @Nullable
    private AEColor color;

    public ColorApplicatorSelectColorPacket(FriendlyByteBuf stream) {
        this.color = stream.readBoolean() ? (AEColor)stream.readEnum(AEColor.class) : null;
    }

    public ColorApplicatorSelectColorPacket(@Nullable AEColor color) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (color != null) {
            data.writeBoolean(true);
            data.writeEnum((Enum)color);
        } else {
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        ColorApplicatorSelectColorPacket.switchColor(player.getMainHandItem(), this.color);
        ColorApplicatorSelectColorPacket.switchColor(player.getOffhandItem(), this.color);
    }

    private static void switchColor(ItemStack stack, AEColor color) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ColorApplicatorItem) {
            ColorApplicatorItem colorApplicator = (ColorApplicatorItem)item;
            colorApplicator.setActiveColor(stack, color);
        }
    }
}

