/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.render.effects.EnergyParticleData;
import appeng.core.AELog;
import appeng.core.AppEngClient;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.registries.GameData;

public class BlockTransitionEffectPacket
extends BasePacket {
    private final BlockPos pos;
    private final BlockState blockState;
    private final Direction direction;
    private final SoundMode soundMode;

    public BlockTransitionEffectPacket(BlockPos pos, BlockState blockState, Direction direction, SoundMode soundMode) {
        this.pos = pos;
        this.blockState = blockState;
        this.direction = direction;
        this.soundMode = soundMode;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBlockPos(pos);
        int blockStateId = GameData.getBlockStateIDMap().getId((Object)blockState);
        if (blockStateId == -1) {
            AELog.warn("Failed to find numeric id for block state %s", blockState);
        }
        data.writeInt(blockStateId);
        data.writeByte(this.direction.ordinal());
        data.writeByte((int)((byte)soundMode.ordinal()));
        this.configureWrite(data);
    }

    public BlockTransitionEffectPacket(FriendlyByteBuf stream) {
        this.pos = stream.readBlockPos();
        int blockStateId = stream.readInt();
        BlockState blockState = (BlockState)GameData.getBlockStateIDMap().byId(blockStateId);
        if (blockState == null) {
            AELog.warn("Received invalid blockstate id %d from server", blockStateId);
            blockState = Blocks.AIR.defaultBlockState();
        }
        this.blockState = blockState;
        this.direction = Direction.values()[stream.readByte()];
        this.soundMode = SoundMode.values()[stream.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(Player player) {
        this.spawnParticles(player.level());
        this.playBreakOrPickupSound();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles(Level level) {
        EnergyParticleData data = new EnergyParticleData(false, this.direction);
        for (int zz = 0; zz < 32; ++zz) {
            if (!AppEngClient.instance().shouldAddParticles(level.getRandom())) continue;
            double x = (float)this.pos.getX() + level.getRandom().nextFloat();
            double y = (float)this.pos.getY() + level.getRandom().nextFloat();
            double z = (float)this.pos.getZ() + level.getRandom().nextFloat();
            double speedX = 0.1f * (float)this.direction.getStepX();
            double speedY = 0.1f * (float)this.direction.getStepY();
            double speedZ = 0.1f * (float)this.direction.getStepZ();
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)data, x, y, z, speedX, speedY, speedZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playBreakOrPickupSound() {
        float pitch;
        float volume;
        SoundEvent soundEvent;
        if (this.soundMode == SoundMode.FLUID) {
            Fluid fluid = this.blockState.getFluidState().getType();
            soundEvent = fluid.getFluidType().getSound(SoundActions.BUCKET_FILL);
            if (soundEvent == null) {
                soundEvent = fluid.is(FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL;
            }
            volume = 1.0f;
            pitch = 1.0f;
        } else if (this.soundMode == SoundMode.BLOCK) {
            SoundType soundType = this.blockState.getSoundType();
            soundEvent = soundType.getBreakSound();
            volume = soundType.volume;
            pitch = soundType.pitch;
        } else {
            return;
        }
        SimpleSoundInstance sound = new SimpleSoundInstance(soundEvent, SoundSource.BLOCKS, (volume + 1.0f) / 2.0f, pitch * 0.8f, SoundInstance.createUnseededRandom(), this.pos);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
    }

    public static enum SoundMode {
        BLOCK,
        FLUID,
        NONE;

    }
}

