/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.network.ClientPacketHandler;
import appeng.core.sync.network.TargetPoint;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;

public class NetworkHandler {
    private static NetworkHandler instance;
    private final ResourceLocation myChannelName;
    private final Consumer<BasePacket> clientHandler;

    public NetworkHandler(ResourceLocation channelName) {
        this.myChannelName = channelName;
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.myChannelName).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).eventNetworkChannel();
        ec.registerObject((Object)this);
        this.clientHandler = (Consumer)DistExecutor.unsafeRunForDist(() -> () -> ClientPacketHandler::onPacketData, () -> () -> pkt -> {});
    }

    public static void init(ResourceLocation channelName) {
        instance = new NetworkHandler(channelName);
    }

    public static NetworkHandler instance() {
        return instance;
    }

    @SubscribeEvent
    public void serverPacket(NetworkEvent.ClientCustomPayloadEvent ev) {
        try {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
            ctx.setPacketHandled(true);
            BasePacket packet = NetworkHandler.deserializePacket(ev.getPayload());
            ServerPlayer player = ctx.getSender();
            ctx.enqueueWork(() -> {
                try {
                    packet.serverPacketData(player);
                }
                catch (IllegalArgumentException e) {
                    AELog.warn(e);
                }
            });
        }
        catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void clientPacket(NetworkEvent.ServerCustomPayloadEvent ev) {
        if (ev instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (this.clientHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                ctx.setPacketHandled(true);
                BasePacket packet = NetworkHandler.deserializePacket(ev.getPayload());
                ctx.enqueueWork(() -> this.clientHandler.accept(packet));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    private static BasePacket deserializePacket(FriendlyByteBuf payload) {
        int packetId = payload.readInt();
        return BasePacketHandler.PacketTypes.getPacket(packetId).parsePacket(payload);
    }

    public ResourceLocation getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(BasePacket message) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            server.getPlayerList().broadcastAll(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public void sendTo(BasePacket message, ServerPlayer player) {
        player.connection.send(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public void sendToAllAround(BasePacket message, TargetPoint point) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            Packet<?> pkt = message.toPacket(NetworkDirection.PLAY_TO_CLIENT);
            server.getPlayerList().broadcast((Player)point.excluded, point.x, point.y, point.z, point.r2, point.level.dimension(), pkt);
        }
    }

    public void sendToServer(BasePacket message) {
        Minecraft.getInstance().getConnection().send(message.toPacket(NetworkDirection.PLAY_TO_SERVER));
    }
}

