/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.parts.CableRenderMode;
import appeng.client.EffectType;
import appeng.client.Hotkeys;
import appeng.client.commands.ClientCommands;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.gui.style.StyleManager;
import appeng.client.guidebook.ConfigValueTagExtension;
import appeng.client.guidebook.PartAnnotationStrategy;
import appeng.client.guidebook.command.GuidebookStructureCommands;
import appeng.client.render.StorageCellClientTooltipComponent;
import appeng.client.render.effects.EnergyParticleData;
import appeng.client.render.effects.ParticleTypes;
import appeng.client.render.overlay.OverlayManager;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.AppEngBase;
import appeng.core.definitions.AEBlocks;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MouseWheelPacket;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.BlockAttackHook;
import appeng.hooks.RenderBlockOutlineHook;
import appeng.init.client.InitAdditionalModels;
import appeng.init.client.InitBlockColors;
import appeng.init.client.InitBlockEntityRenderers;
import appeng.init.client.InitBuiltInModels;
import appeng.init.client.InitEntityLayerDefinitions;
import appeng.init.client.InitEntityRendering;
import appeng.init.client.InitItemColors;
import appeng.init.client.InitItemModelsProperties;
import appeng.init.client.InitParticleFactories;
import appeng.init.client.InitRenderTypes;
import appeng.init.client.InitScreens;
import appeng.init.client.InitStackRenderHandlers;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.siteexport.AESiteExporter;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStorageSkyProperties;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import guideme.Guide;
import guideme.GuidesCommon;
import guideme.PageAnchor;
import guideme.compiler.TagCompiler;
import guideme.extensions.Extension;
import guideme.scene.ImplicitAnnotationStrategy;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class AppEngClient
extends AppEngBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppEngClient.class);
    public static final ResourceLocation GUIDE_ID = AppEng.makeId("guide");
    private static AppEngClient INSTANCE;
    private CableRenderMode prevCableRenderMode = CableRenderMode.STANDARD;
    private final Guide guide;

    public AppEngClient() {
        InitBuiltInModels.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerClientCommands();
        modEventBus.addListener(this::registerClientTooltipComponents);
        modEventBus.addListener(this::registerParticleFactories);
        modEventBus.addListener(this::modelRegistryEventAdditionalModels);
        modEventBus.addListener(this::modelRegistryEvent);
        modEventBus.addListener(this::registerBlockColors);
        modEventBus.addListener(this::registerItemColors);
        modEventBus.addListener(this::registerEntityRenderers);
        modEventBus.addListener(this::registerEntityLayerDefinitions);
        modEventBus.addListener(this::registerHotkeys);
        modEventBus.addListener(this::registerDimensionSpecialEffects);
        BlockAttackHook.install();
        RenderBlockOutlineHook.install();
        this.guide = this.createGuide();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, e -> {
            if (e.phase == TickEvent.Phase.START) {
                this.updateCableRenderMode();
            }
        });
        modEventBus.addListener(this::clientSetup);
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            PendingCraftingJobs.clearPendingJobs();
            PinnedKeys.clearPinnedKeys();
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                this.tickPinnedKeys(Minecraft.getInstance());
                Hotkeys.checkHotkeys();
            }
        });
    }

    private void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(SpatialStorageDimensionIds.DIMENSION_TYPE_ID.location(), SpatialStorageSkyProperties.INSTANCE);
    }

    private void registerClientCommands() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            CommandDispatcher dispatcher = evt.getDispatcher();
            LiteralArgumentBuilder builder = Commands.literal((String)"ae2client");
            if (AEConfig.instance().isDebugToolsEnabled()) {
                for (ClientCommands.CommandBuilder commandBuilder : ClientCommands.DEBUG_COMMANDS) {
                    commandBuilder.build((LiteralArgumentBuilder<CommandSourceStack>)builder);
                }
            }
            dispatcher.register(builder);
        });
    }

    private Guide createGuide() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            MinecraftServer server = evt.getServer();
            CommandDispatcher dispatcher = server.getCommands().getDispatcher();
            GuidebookStructureCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        });
        return Guide.builder((ResourceLocation)GUIDE_ID).folder("ae2guide").extension(ImplicitAnnotationStrategy.EXTENSION_POINT, (Extension)new PartAnnotationStrategy()).extension(TagCompiler.EXTENSION_POINT, (Extension)new ConfigValueTagExtension()).build();
    }

    private void tickPinnedKeys(Minecraft minecraft) {
        if (minecraft.screen == null) {
            PinnedKeys.prune();
        }
    }

    @Override
    public Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    @Override
    public void registerHotkey(String id) {
        Hotkeys.registerHotkey(id);
    }

    private void registerHotkeys(RegisterKeyMappingsEvent e) {
        Hotkeys.finalizeRegistration(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    public static AppEngClient instance() {
        return Objects.requireNonNull(INSTANCE, "AppEngClient is not initialized");
    }

    public void registerParticleFactories(RegisterParticleProvidersEvent event) {
        InitParticleFactories.init();
    }

    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        InitBlockColors.init(event.getBlockColors());
    }

    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        InitItemColors.init(event.getItemColors());
    }

    private void registerClientTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(StorageCellTooltipComponent.class, StorageCellClientTooltipComponent::new);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            try {
                this.postClientSetup(minecraft);
            }
            catch (Throwable e) {
                LOGGER.error("AE2 failed postClientSetup", e);
                throw new RuntimeException(e);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(this::wheelEvent);
        MinecraftForge.EVENT_BUS.register((Object)OverlayManager.getInstance());
    }

    private void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        InitEntityRendering.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
    }

    private void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        InitEntityLayerDefinitions.init((modelLayerLocation, layerDefinition) -> event.registerLayerDefinition(modelLayerLocation, () -> layerDefinition));
    }

    private void postClientSetup(Minecraft minecraft) {
        StyleManager.initialize(minecraft.getResourceManager());
        InitScreens.init();
        InitStackRenderHandlers.init();
        InitRenderTypes.init();
        if (!FMLLoader.isProduction()) {
            AESiteExporter.initialize();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistryEventAdditionalModels(ModelEvent.RegisterAdditional event) {
        InitAdditionalModels.init(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
        InitBlockEntityRenderers.init();
        InitItemModelsProperties.init();
    }

    private void wheelEvent(InputEvent.MouseScrollingEvent me) {
        if (me.getScrollDelta() == 0.0) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            boolean mainHand = player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof IMouseWheelItem;
            boolean offHand = player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof IMouseWheelItem;
            if (mainHand || offHand) {
                NetworkHandler.instance().sendToServer(new MouseWheelPacket(me.getScrollDelta() > 0.0));
                me.setCanceled(true);
            }
        }
    }

    public boolean shouldAddParticles(RandomSource r) {
        return switch ((ParticleStatus)Minecraft.getInstance().options.particles().get()) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleStatus.ALL -> true;
            case ParticleStatus.DECREASED -> r.nextBoolean();
            case ParticleStatus.MINIMAL -> false;
        };
    }

    @Override
    public HitResult getCurrentMouseOver() {
        return Minecraft.getInstance().hitResult;
    }

    @Override
    public void spawnEffect(EffectType effect, Level level, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Vibrant: {
                    this.spawnVibrant(level, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(level, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(level, posX, posY, posZ);
                    return;
                }
            }
        }
    }

    private void spawnVibrant(Level level, double x, double y, double z) {
        if (AppEngClient.instance().shouldAddParticles(level.getRandom())) {
            double d0 = (double)(level.getRandom().nextFloat() - 0.5f) * 0.26;
            double d1 = (double)(level.getRandom().nextFloat() - 0.5f) * 0.26;
            double d2 = (double)(level.getRandom().nextFloat() - 0.5f) * 0.26;
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.VIBRANT, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
        }
    }

    private void spawnEnergy(Level level, double posX, double posY, double posZ) {
        RandomSource random = level.getRandom();
        float x = (float)((double)(Math.abs(random.nextInt()) % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Math.abs(random.nextInt()) % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Math.abs(random.nextInt()) % 100) * 0.01 - 0.5) * 0.7f;
        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)EnergyParticleData.FOR_BLOCK, posX + (double)x, posY + (double)y, posZ + (double)z, (double)(-x) * 0.1, (double)(-y) * 0.1, (double)(-z) * 0.1);
    }

    private void spawnLightning(Level level, double posX, double posY, double posZ) {
        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.LIGHTNING, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
    }

    private void updateCableRenderMode() {
        CableRenderMode currentMode = this.getCableRenderMode();
        if (currentMode == this.prevCableRenderMode) {
            return;
        }
        this.prevCableRenderMode = currentMode;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        int viewDistance = (int)Math.ceil(mc.levelRenderer.getLastViewDistance());
        ChunkPos.rangeClosed((ChunkPos)mc.player.chunkPosition(), (int)viewDistance).forEach(chunkPos -> {
            LevelChunk chunk = mc.level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
            if (chunk != null) {
                for (int i = 0; i < chunk.getSectionsCount(); ++i) {
                    LevelChunkSection section = chunk.getSection(i);
                    if (!section.maybeHas(state -> state.is((Block)AEBlocks.CABLE_BUS.block()))) continue;
                    mc.levelRenderer.setSectionDirty(chunkPos.x, chunk.getSectionYFromSectionIndex(i), chunkPos.z);
                }
            }
        });
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        if (Platform.isServer()) {
            return super.getCableRenderMode();
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return CableRenderMode.STANDARD;
        }
        return this.getCableRenderModeForPlayer((Player)mc.player);
    }

    @Override
    public void openGuideAtPreviousPage(ResourceLocation initialPage) {
        try {
            GuidesCommon.openGuide((Player)Minecraft.getInstance().player, (ResourceLocation)GUIDE_ID);
        }
        catch (Exception e) {
            LOGGER.error("Failed to open guide.", (Throwable)e);
        }
    }

    @Override
    public void openGuideAtAnchor(appeng.client.guidebook.PageAnchor anchor) {
        try {
            GuidesCommon.openGuide((Player)Minecraft.getInstance().player, (ResourceLocation)GUIDE_ID, (PageAnchor)new PageAnchor(anchor.pageId(), anchor.anchor()));
        }
        catch (Exception e) {
            LOGGER.error("Failed to open guide at {}.", (Object)anchor, (Object)e);
        }
    }

    public Guide getGuide() {
        return this.guide;
    }
}

