/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import appeng.thirdparty.fabric.MutableQuadView;
import appeng.thirdparty.fabric.RenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MeteoriteCompassBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<Float> ROTATION = new ModelProperty();
    private final BakedModel base;
    private final BakedModel pointer;
    private float fallbackRotation = 0.0f;

    public MeteoriteCompassBakedModel(BakedModel base, BakedModel pointer) {
        this.base = base;
        this.pointer = pointer;
    }

    public BakedModel getPointer() {
        return this.pointer;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        Float rotationFromData = (Float)extraData.get(ROTATION);
        float rotation = rotationFromData != null ? rotationFromData.floatValue() : this.fallbackRotation;
        RenderContext.QuadTransform transform = quad -> {
            Quaternionf quaternion = new Quaternionf().rotationY(this.fallbackRotation);
            Vector3f pos = new Vector3f();
            for (int i = 0; i < 4; ++i) {
                quad.copyPos(i, pos);
                pos.add(-0.5f, -0.5f, -0.5f);
                pos.rotate((Quaternionfc)quaternion);
                pos.add(0.5f, 0.5f, 0.5f);
                quad.pos(i, pos);
            }
            return true;
        };
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.base.getQuads(state, side, rand, extraData, renderType));
        if (side == null && state == null) {
            MutableQuadView quadView = MutableQuadView.getInstance();
            for (BakedQuad bakedQuad : this.pointer.getQuads(state, side, rand, extraData, renderType)) {
                quadView.fromVanilla(bakedQuad, null);
                transform.transform(quadView);
                quads.add(quadView.toBlockBakedQuad());
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.base.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.base.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.base.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return new ItemOverrides(){

            public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                if (level != null && entity instanceof LocalPlayer) {
                    Player player = (Player)entity;
                    float offRads = (float)((double)(player.getYRot() / 180.0f * (float)Math.PI) + Math.PI);
                    MeteoriteCompassBakedModel.this.fallbackRotation = MeteoriteCompassBakedModel.getAnimatedRotation(player.blockPosition(), true, offRads);
                } else {
                    MeteoriteCompassBakedModel.this.fallbackRotation = MeteoriteCompassBakedModel.getAnimatedRotation(null, false, 0.0f);
                }
                return originalModel;
            }
        };
    }

    public static float getAnimatedRotation(@Nullable BlockPos pos, boolean prefetch, float playerRotation) {
        if (pos != null) {
            CompassResult cr = CompassManager.INSTANCE.getCompassDirection(0L, pos.getX(), pos.getY(), pos.getZ());
            if (prefetch) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        CompassManager.INSTANCE.getCompassDirection(0L, pos.getX() + i - 1, pos.getY(), pos.getZ() + j - 1);
                    }
                }
            }
            if (cr.isValidResult()) {
                if (cr.isSpin()) {
                    long timeMillis = System.currentTimeMillis();
                    return (float)(timeMillis %= 500L) / 500.0f * (float)Math.PI * 2.0f;
                }
                return (float)cr.getRad() + playerRotation;
            }
        }
        long timeMillis = System.currentTimeMillis();
        return (float)(timeMillis %= 3000L) / 3000.0f * (float)Math.PI * 2.0f;
    }
}

