/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.api.stacks.AEFluidKey;
import appeng.client.gui.Icon;
import appeng.client.gui.style.BackgroundGenerator;
import appeng.client.gui.style.FluidBlitter;
import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.color.LightDarkMode;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.style.ResolvedTextStyle;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface RenderContext {
    public LightDarkMode lightDarkMode();

    default public boolean isDarkMode() {
        return this.lightDarkMode() == LightDarkMode.DARK_MODE;
    }

    public GuiGraphics guiGraphics();

    default public PoseStack poseStack() {
        return this.guiGraphics().pose();
    }

    public LytRect viewport();

    public int resolveColor(ColorValue var1);

    public void fillRect(LytRect var1, ColorValue var2, ColorValue var3, ColorValue var4, ColorValue var5);

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft) {
        this.fillTexturedRect(rect, texture, topLeft, topRight, bottomRight, bottomLeft, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void fillTexturedRect(LytRect var1, AbstractTexture var2, ColorValue var3, ColorValue var4, ColorValue var5, ColorValue var6, float var7, float var8, float var9, float var10);

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture) {
        this.fillTexturedRect(rect, texture, (ColorValue)ConstantColor.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue color) {
        this.fillTexturedRect(rect, texture, color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, TextureAtlasSprite sprite, ColorValue color) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(sprite.atlasLocation());
        this.fillTexturedRect(rect, texture, color, color, color, color, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1());
    }

    default public void drawIcon(int x, int y, Icon icon, ColorValue color) {
        float u0 = (float)icon.x / 256.0f;
        float v0 = (float)icon.y / 256.0f;
        float u1 = (float)(icon.x + icon.width) / 256.0f;
        float v1 = (float)(icon.y + icon.height) / 256.0f;
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(Icon.TEXTURE);
        this.fillTexturedRect(new LytRect(x, y, icon.width, icon.height), texture, color, color, color, color, u0, v0, u1, v1);
    }

    default public void fillTexturedRect(LytRect rect, ResourceLocation textureId) {
        this.fillTexturedRect(rect, textureId, (ColorValue)ConstantColor.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, ResourceLocation textureId, ColorValue color) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(textureId);
        this.fillTexturedRect(rect, texture, color);
    }

    public void fillTriangle(Vec2 var1, Vec2 var2, Vec2 var3, ColorValue var4);

    default public Font font() {
        return Minecraft.getInstance().font;
    }

    default public float getAdvance(int codePoint, ResolvedTextStyle style) {
        return this.font().getFontSet(style.font()).getGlyphInfo(codePoint, false).getAdvance(Boolean.TRUE.equals(style.bold()));
    }

    default public float getWidth(String text, ResolvedTextStyle style) {
        return (float)text.codePoints().mapToDouble(cp -> this.getAdvance(cp, style)).sum();
    }

    default public void renderText(String text, ResolvedTextStyle style, float x, float y) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        this.renderTextInBatch(text, style, x, y, (MultiBufferSource)bufferSource);
        bufferSource.endBatch();
    }

    default public void renderTextInBatch(String text, ResolvedTextStyle style, float x, float y, MultiBufferSource buffers) {
        Style effectiveStyle = Style.EMPTY.withBold(Boolean.valueOf(style.bold())).withItalic(Boolean.valueOf(style.italic())).withUnderlined(Boolean.valueOf(style.underlined())).withStrikethrough(Boolean.valueOf(style.strikethrough())).withFont(style.font());
        Matrix4f matrix = this.poseStack().last().pose();
        if (style.fontScale() != 1.0f) {
            matrix = new Matrix4f((Matrix4fc)matrix);
            matrix.scale(style.fontScale(), style.fontScale(), 1.0f);
            matrix.translate((Vector3fc)new Vector3f(x / style.fontScale(), y / style.fontScale(), 0.0f));
            x = 0.0f;
            y = 0.0f;
        }
        this.font().drawInBatch((Component)Component.literal((String)text).withStyle(effectiveStyle), x, y, this.resolveColor(style.color()), false, matrix, buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    default public void fillRect(int x, int y, int width, int height, ColorValue color) {
        this.fillRect(new LytRect(x, y, width, height), color);
    }

    default public void fillRect(LytRect rect, ColorValue color) {
        this.fillRect(rect, color, color, color, color);
    }

    default public void fillGradientVertical(LytRect rect, ColorValue top, ColorValue bottom) {
        this.fillRect(rect, top, top, bottom, bottom);
    }

    default public void fillGradientVertical(int x, int y, int width, int height, ColorValue top, ColorValue bottom) {
        this.fillGradientVertical(new LytRect(x, y, width, height), top, bottom);
    }

    default public void fillGradientHorizontal(LytRect rect, ColorValue left, ColorValue right) {
        this.fillRect(rect, left, right, right, left);
    }

    default public void fillGradientHorizontal(int x, int y, int width, int height, ColorValue left, ColorValue right) {
        this.fillGradientHorizontal(new LytRect(x, y, width, height), left, right);
    }

    default public MultiBufferSource.BufferSource beginBatch() {
        return MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
    }

    default public void endBatch(MultiBufferSource.BufferSource batch) {
        batch.endBatch();
    }

    default public void renderItem(ItemStack stack, int x, int y, float width, float height) {
        this.renderItem(stack, x, y, 0, width, height);
    }

    default public void renderFluid(Fluid fluid, @Nullable CompoundTag tag, int x, int y, int z, int width, int height) {
        AEFluidKey key = AEFluidKey.of(fluid, tag);
        FluidBlitter.create(key).dest(x, y, width, height).blit(this.guiGraphics());
    }

    public void renderItem(ItemStack var1, int var2, int var3, int var4, float var5, float var6);

    default public void renderPanel(LytRect bounds) {
        BackgroundGenerator.draw(bounds.width(), bounds.height(), this.guiGraphics(), bounds.x(), bounds.y());
    }

    default public void pushScissor(LytRect bounds) {
        Vector3f dest = new Vector3f();
        this.poseStack().last().pose().transformPosition((float)bounds.x(), (float)bounds.y(), 0.0f, dest);
        this.guiGraphics().enableScissor((int)dest.x(), (int)dest.y(), (int)(dest.x() + (float)bounds.width()), (int)(dest.y() + (float)bounds.height()));
    }

    default public void popScissor() {
        this.guiGraphics().disableScissor();
    }
}

