/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
@OnlyIn(value=Dist.CLIENT)
public class GuidebookStructureCommands {
    private static final Logger LOG = LoggerFactory.getLogger(GuidebookStructureCommands.class);
    @Nullable
    private static String lastOpenedOrSavedPath;
    private static final String[] FILE_PATTERNS;
    private static final String FILE_PATTERN_DESC = "Structure NBT Files (*.snbt, *.nbt)";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder rootCommand = LiteralArgumentBuilder.literal((String)"ae2guide");
        GuidebookStructureCommands.registerImportCommand((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        GuidebookStructureCommands.registerExportCommand((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        dispatcher.register(rootCommand);
    }

    private static void registerImportCommand(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder importSubcommand = LiteralArgumentBuilder.literal((String)"importstructure");
        importSubcommand.requires(source -> Minecraft.getInstance().hasSingleplayerServer());
        importSubcommand.then(Commands.argument((String)"origin", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos origin = BlockPosArgument.getBlockPos((CommandContext)context, (String)"origin");
            GuidebookStructureCommands.importStructure(((CommandSourceStack)context.getSource()).getLevel(), origin);
            return 0;
        }));
        rootCommand.then((ArgumentBuilder)importSubcommand);
    }

    private static void importStructure(ServerLevel level, BlockPos origin) {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        LocalPlayer player = minecraft.player;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(GuidebookStructureCommands::pickFileForOpen, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            lastOpenedOrSavedPath = selectedPath;
            StructureTemplateManager manager = server.getStructureManager();
            try {
                CompoundTag compound;
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    String textInFile = Files.readString(Paths.get(selectedPath, new String[0]), StandardCharsets.UTF_8);
                    try {
                        compound = NbtUtils.snbtToStructure((String)textInFile);
                    }
                    catch (CommandSyntaxException e) {
                        LOG.error("Failed to parse structure.", (Throwable)e);
                        player.sendSystemMessage((Component)Component.literal((String)e.toString()));
                        return null;
                    }
                }
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((String)selectedPath));){
                    compound = NbtIo.readCompressed((InputStream)is);
                }
                StructureTemplate structure = manager.readStructure(compound);
                if (!structure.placeInWorld((ServerLevelAccessor)level, origin, origin, new StructurePlaceSettings(), (RandomSource)new SingleThreadedRandomSource(0L), 2)) {
                    player.sendSystemMessage((Component)Component.literal((String)"Failed to place structure"));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Placed structure"));
                }
            }
            catch (Exception e) {
                LOG.error("Failed to place structure.", (Throwable)e);
                player.sendSystemMessage((Component)Component.literal((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.screen instanceof PauseScreen) {
                minecraft.setScreen(null);
            }
        }, (Executor)minecraft);
    }

    private static void registerExportCommand(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder exportSubcommand = LiteralArgumentBuilder.literal((String)"exportstructure");
        exportSubcommand.requires(source -> Minecraft.getInstance().hasSingleplayerServer());
        exportSubcommand.then(Commands.argument((String)"origin", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"sizeX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"sizeY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"sizeZ", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            BlockPos origin = BlockPosArgument.getBlockPos((CommandContext)context, (String)"origin");
            int sizeX = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeX");
            int sizeY = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeY");
            int sizeZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeZ");
            Vec3i size = new Vec3i(sizeX, sizeY, sizeZ);
            GuidebookStructureCommands.exportStructure(((CommandSourceStack)context.getSource()).getLevel(), origin, size);
            return 0;
        })))));
        rootCommand.then((ArgumentBuilder)exportSubcommand);
    }

    private static void exportStructure(ServerLevel level, BlockPos origin, Vec3i size) {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        LocalPlayer player = minecraft.player;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(GuidebookStructureCommands::pickFileForSave, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            try {
                BlockPos to = BlockPos.betweenClosedStream((BlockPos)origin, (BlockPos)origin.offset(size.getX() - 1, size.getY() - 1, size.getZ() - 1)).filter(pos -> !level.getBlockState(pos).isAir()).reduce(origin, (blockPos, blockPos2) -> new BlockPos(Math.max(blockPos.getX(), blockPos2.getX()), Math.max(blockPos.getY(), blockPos2.getY()), Math.max(blockPos.getZ(), blockPos2.getZ())));
                BlockPos actualSize = new BlockPos(1 + to.getX() - origin.getX(), 1 + to.getY() - origin.getY(), 1 + to.getZ() - origin.getZ());
                StructureTemplate structureTemplate = new StructureTemplate();
                structureTemplate.fillFromWorld((Level)level, origin, (Vec3i)actualSize, false, Blocks.AIR);
                CompoundTag compound = structureTemplate.save(new CompoundTag());
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    Files.writeString(Paths.get(selectedPath, new String[0]), (CharSequence)NbtUtils.structureToSnbt((CompoundTag)compound), StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    NbtIo.writeCompressed((CompoundTag)compound, (File)new File((String)selectedPath));
                }
                player.sendSystemMessage((Component)Component.literal((String)"Saved structure"));
            }
            catch (IOException e) {
                LOG.error("Failed to save structure.", (Throwable)e);
                player.sendSystemMessage((Component)Component.literal((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.screen instanceof PauseScreen) {
                minecraft.setScreen(null);
            }
        }, (Executor)minecraft);
    }

    private static String pickFileForOpen() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Load Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)GuidebookStructureCommands.createFilterPatterns(stack), (CharSequence)FILE_PATTERN_DESC, (boolean)false);
            return string;
        }
    }

    private static String pickFileForSave() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)GuidebookStructureCommands.createFilterPatterns(stack), (CharSequence)FILE_PATTERN_DESC);
            return string;
        }
    }

    private static PointerBuffer createFilterPatterns(MemoryStack stack) {
        PointerBuffer filterPatternsBuffer = stack.mallocPointer(FILE_PATTERNS.length);
        for (String pattern : FILE_PATTERNS) {
            filterPatternsBuffer.put(stack.UTF8((CharSequence)pattern));
        }
        filterPatternsBuffer.flip();
        return filterPatternsBuffer;
    }

    static {
        FILE_PATTERNS = new String[]{"*.snbt", "*.nbt"};
    }
}

