/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class TabButton
extends Button
implements ITooltip {
    private Style style = Style.BOX;
    private Icon icon = null;
    private ItemStack item;
    private boolean selected;

    public TabButton(Icon ico, Component message, Button.OnPress onPress) {
        super(0, 0, 22, 22, message, onPress, Button.DEFAULT_NARRATION);
        this.icon = ico;
    }

    public TabButton(ItemStack ico, Component message, Button.OnPress onPress) {
        super(0, 0, 22, 22, message, onPress, Button.DEFAULT_NARRATION);
        this.item = ico;
    }

    public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partial) {
        if (this.visible) {
            Icon backdrop = switch (this.style) {
                default -> throw new IncompatibleClassChangeError();
                case Style.CORNER -> {
                    if (this.isFocused()) {
                        yield Icon.TAB_BUTTON_BACKGROUND_BORDERLESS_FOCUS;
                    }
                    yield Icon.TAB_BUTTON_BACKGROUND_BORDERLESS;
                }
                case Style.BOX -> {
                    if (this.isFocused()) {
                        yield Icon.TAB_BUTTON_BACKGROUND_FOCUS;
                    }
                    yield Icon.TAB_BUTTON_BACKGROUND;
                }
                case Style.HORIZONTAL -> this.isFocused() ? Icon.HORIZONTAL_TAB_FOCUS : (this.selected ? Icon.HORIZONTAL_TAB_SELECTED : Icon.HORIZONTAL_TAB);
            };
            backdrop.getBlitter().dest(this.getX(), this.getY()).blit(guiGraphics);
            int iconX = switch (this.style) {
                default -> throw new IncompatibleClassChangeError();
                case Style.CORNER -> 4;
                case Style.BOX -> 3;
                case Style.HORIZONTAL -> 1;
            };
            int iconY = 3;
            if (this.icon != null) {
                this.icon.getBlitter().dest(this.getX() + iconX, this.getY() + iconY).blit(guiGraphics);
            }
            if (this.item != null) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 100.0f);
                guiGraphics.renderItem(this.item, this.getX() + iconX, this.getY() + iconY);
                Font font = Minecraft.getInstance().font;
                guiGraphics.renderItemDecorations(font, this.item, this.getX() + iconX, this.getY() + iconY);
                pose.popPose();
            }
        }
    }

    @Override
    public List<Component> getTooltipMessage() {
        return Collections.singletonList(this.getMessage());
    }

    @Override
    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static enum Style {
        CORNER,
        BOX,
        HORIZONTAL;

    }
}

