/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.me.items.EncodingModePanel;
import appeng.client.gui.me.items.PatternEncodingTermScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;

public class SmithingTableEncodingPanel
extends EncodingModePanel {
    private static final Blitter BG = Blitter.texture("guis/pattern_modes.png").src(128, 70, 126, 68);
    private final ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> this.menu.clear());
    private final ToggleButton substitutionsBtn;
    private final Slot resultSlot;

    public SmithingTableEncodingPanel(PatternEncodingTermScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.clearBtn.setHalfSize(true);
        widgets.add("smithingTableClearPattern", (AbstractWidget)this.clearBtn);
        this.substitutionsBtn = this.createSubstitutionButton(widgets);
        this.resultSlot = new Slot((Container)new SimpleContainer(1), 0, 0, 0);
        this.menu.addClientSideSlot(this.resultSlot, SlotSemantics.SMITHING_TABLE_RESULT);
    }

    @Override
    public ItemStack getTabIconItem() {
        return Items.SMITHING_TABLE.getDefaultInstance();
    }

    @Override
    public Component getTabTooltip() {
        return GuiText.SmithingTablePattern.text();
    }

    private ToggleButton createSubstitutionButton(WidgetContainer widgets) {
        ToggleButton button = new ToggleButton(Icon.SUBSTITUTION_ENABLED, Icon.SUBSTITUTION_DISABLED, this.menu::setSubstitute);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.SubstitutionsOn.text(), ButtonToolTips.SubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.SubstitutionsOff.text(), ButtonToolTips.SubstitutionsDescDisabled.text()));
        widgets.add("smithingTableSubstitutions", (AbstractWidget)button);
        return button;
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        BG.dest(bounds.getX() + 9, bounds.getY() + bounds.getHeight() - 164).blit(guiGraphics);
    }

    @Override
    public void updateBeforeRender() {
        this.substitutionsBtn.setState(this.menu.substitute);
        SimpleContainer container = new SimpleContainer(3);
        container.setItem(0, this.menu.getSmithingTableTemplateSlot().getItem());
        container.setItem(1, this.menu.getSmithingTableBaseSlot().getItem());
        container.setItem(2, this.menu.getSmithingTableAdditionSlot().getItem());
        Level level = this.menu.getPlayer().level();
        SmithingRecipe recipe = level.getRecipeManager().getRecipeFor(RecipeType.SMITHING, (Container)container, level).orElse(null);
        if (recipe == null) {
            this.resultSlot.set(ItemStack.EMPTY);
        } else {
            this.resultSlot.set(recipe.assemble((Container)container, level.registryAccess()));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearBtn.setVisibility(visible);
        this.substitutionsBtn.setVisibility(visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_TEMPLATE, !visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_BASE, !visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_ADDITION, !visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_RESULT, !visible);
    }
}

