/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.core.AEConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public class StackSizeRenderer {
    private static void renderSizeLabel(Matrix4f matrix, Font fontRenderer, float xPos, float yPos, String text, boolean largeFonts) {
        float scaleFactor = largeFonts ? 0.85f : 0.5f;
        float inverseScaleFactor = 1.0f / scaleFactor;
        int offset = largeFonts ? 0 : -1;
        RenderSystem.disableBlend();
        int X = (int)((xPos + (float)offset + 16.0f - (float)fontRenderer.width(text) * scaleFactor) * inverseScaleFactor);
        int Y = (int)((yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        fontRenderer.drawInBatch(text, (float)X, (float)Y, 0xFFFFFF, true, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.endBatch();
        RenderSystem.enableBlend();
    }

    public static void renderSizeLabel(GuiGraphics guiGraphics, Font fontRenderer, float xPos, float yPos, String text) {
        StackSizeRenderer.renderSizeLabel(guiGraphics, fontRenderer, xPos, yPos, text, AEConfig.instance().isUseLargeFonts());
    }

    public static void renderSizeLabel(GuiGraphics guiGraphics, Font fontRenderer, float xPos, float yPos, String text, boolean largeFonts) {
        float scaleFactor = largeFonts ? 0.85f : 0.5f;
        PoseStack stack = guiGraphics.pose();
        stack.pushPose();
        stack.translate(0.0f, 0.0f, 200.0f);
        stack.scale(scaleFactor, scaleFactor, scaleFactor);
        StackSizeRenderer.renderSizeLabel(stack.last().pose(), fontRenderer, xPos, yPos, text, largeFonts);
        stack.popPose();
    }
}

