/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AEBaseInvBlockEntity
extends AEBaseBlockEntity
implements InternalInventoryHost {
    public AEBaseInvBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        InternalInventory inv = this.getInternalInventory();
        if (inv != InternalInventory.empty()) {
            CompoundTag opt = data.getCompound("inv");
            for (int x = 0; x < inv.size(); ++x) {
                CompoundTag item = opt.getCompound("item" + x);
                inv.setItemDirect(x, ItemStack.of((CompoundTag)item));
            }
        }
    }

    public abstract InternalInventory getInternalInventory();

    @Override
    public void saveAdditional(CompoundTag data) {
        super.saveAdditional(data);
        InternalInventory inv = this.getInternalInventory();
        if (inv != InternalInventory.empty()) {
            CompoundTag opt = new CompoundTag();
            for (int x = 0; x < inv.size(); ++x) {
                CompoundTag item = new CompoundTag();
                ItemStack is = inv.getStackInSlot(x);
                if (!is.isEmpty()) {
                    is.save(item);
                }
                opt.put("item" + x, (Tag)item);
            }
            data.put("inv", (Tag)opt);
        }
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        InternalInventory inv = this.getInternalInventory();
        for (ItemStack stack : inv) {
            GenericStack genericStack = GenericStack.unwrapItemStack(stack);
            if (genericStack != null) {
                genericStack.what().addDrops(genericStack.amount(), drops, level, pos);
                continue;
            }
            drops.add(stack);
        }
    }

    @Override
    public void clearContent() {
        super.clearContent();
        this.getInternalInventory().clear();
    }

    @Override
    public abstract void onChangeInventory(InternalInventory var1, int var2);

    protected InternalInventory getExposedInventoryForSide(Direction side) {
        return this.getInternalInventory();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == null) {
                return LazyOptional.of(this.getInternalInventory()::toItemHandler);
            }
            return LazyOptional.of(() -> this.getExposedInventoryForSide(facing).toItemHandler());
        }
        return super.getCapability(capability, facing);
    }
}

