/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.storage.SkyChestBlockEntity;
import appeng.core.definitions.AEBlockEntities;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.SkyChestMenu;
import appeng.menu.locator.MenuLocators;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SkyChestBlock
extends AEBaseEntityBlock<SkyChestBlockEntity>
implements SimpleWaterloggedBlock {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.0625;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, BlockBehaviour.Properties props) {
        super(props);
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.horizontalFacing();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        SkyChestBlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = (SkyChestBlockEntity)this.getBlockEntity((BlockGetter)level, pos)) != null) {
            MenuOpener.open(SkyChestMenu.TYPE, player, MenuLocators.forBlockEntity(blockEntity));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.getBlockEntity(pos, AEBlockEntities.SKY_CHEST).ifPresent(SkyChestBlockEntity::recheckOpen);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SkyChestBlockEntity sk = (SkyChestBlockEntity)this.getBlockEntity(level, pos);
        Direction up = sk != null ? sk.getTop() : Direction.UP;
        return SHAPES.get(up);
    }

    private static AABB computeAABB(Direction up) {
        double offsetX = up.getStepX() == 0 ? 0.06 : 0.0;
        double offsetY = up.getStepY() == 0 ? 0.06 : 0.0;
        double offsetZ = up.getStepZ() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (up.getStepX() < 0 ? 0.0 : (double)up.getStepX() * 0.0625));
        double minY = Math.max(0.0, offsetY + (up.getStepY() < 0 ? 0.0625 : (double)up.getStepY() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (up.getStepZ() < 0 ? 0.0 : (double)up.getStepZ() * 0.0625));
        double maxX = Math.min(1.0, 1.0 - offsetX - (up.getStepX() < 0 ? 0.0625 : (double)up.getStepX() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (up.getStepY() < 0 ? 0.0 : (double)up.getStepY() * 0.0625));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (up.getStepZ() < 0 ? 0.0625 : (double)up.getStepZ() * 0.0));
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public BlockState updateShape(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(blockState, facing, facingState, level, currentPos, facingPos);
    }

    static {
        for (Direction up : Direction.values()) {
            AABB aabb = SkyChestBlock.computeAABB(up);
            SHAPES.put(up, Shapes.create((AABB)aabb));
        }
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

