/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.storage.cells.CellState;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.core.localization.PlayerMessages;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ChestBlock
extends AEBaseEntityBlock<ChestBlockEntity> {
    public static final BooleanProperty LIGHTS_ON = BooleanProperty.create((String)"lights_on");

    public ChestBlock() {
        super(ChestBlock.metalProps());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIGHTS_ON});
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.full();
    }

    @Override
    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, ChestBlockEntity be) {
        CellState cellState = CellState.ABSENT;
        if (be.getCellCount() >= 1) {
            cellState = be.getCellStatus(0);
        }
        return (BlockState)currentState.setValue((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(be.isPowered() && cellState != CellState.ABSENT));
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player p, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        ChestBlockEntity be = (ChestBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null && !InteractionUtil.isInAlternateUseMode(p)) {
            if (!level.isClientSide()) {
                if (hit.getDirection() == be.getTop()) {
                    if (!be.openGui(p)) {
                        p.displayClientMessage((Component)PlayerMessages.ChestCannotReadStorageCell.text(), true);
                    }
                } else {
                    be.openCellInventoryMenu(p);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

