/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseEntityBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractCraftingUnitBlock<T extends CraftingBlockEntity>
extends AEBaseEntityBlock<T> {
    public static final BooleanProperty FORMED = BooleanProperty.create((String)"formed");
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public final ICraftingUnitType type;

    public AbstractCraftingUnitBlock(BlockBehaviour.Properties props, ICraftingUnitType type) {
        super(props);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FORMED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{FORMED});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity te = level.getBlockEntity(currentPos);
        if (te != null) {
            te.requestModelDataUpdate();
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        CraftingBlockEntity cp = (CraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.updateMultiBlock(fromPos);
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() == state.getBlock()) {
            return;
        }
        CraftingBlockEntity cp = (CraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cp != null) {
            cp.breakCluster();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player p, InteractionHand hand, BlockHitResult hit) {
        CraftingBlockEntity tg = (CraftingBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tg != null && !InteractionUtil.isInAlternateUseMode(p) && tg.isFormed() && tg.isActive()) {
            if (!level.isClientSide()) {
                hit.getDirection();
                MenuOpener.open(CraftingCPUMenu.TYPE, p, MenuLocators.forBlockEntity(tg));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.use(state, level, pos, p, hand, hit);
    }
}

