/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.items.misc.WrappedGenericStack;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public record GenericStack(AEKey what, long amount) {
    public GenericStack {
        Objects.requireNonNull(what, "what");
    }

    @Nullable
    public static GenericStack readBuffer(FriendlyByteBuf buffer) {
        if (!buffer.readBoolean()) {
            return null;
        }
        AEKey what = AEKey.readKey(buffer);
        if (what == null) {
            return null;
        }
        return new GenericStack(what, buffer.readVarLong());
    }

    public static void writeBuffer(@Nullable GenericStack stack, FriendlyByteBuf buffer) {
        if (stack == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            AEKey.writeKey(buffer, stack.what);
            buffer.writeVarLong(stack.amount);
        }
    }

    @Nullable
    public static GenericStack readTag(CompoundTag tag) {
        if (tag.isEmpty()) {
            return null;
        }
        AEKey key = AEKey.fromTagGeneric(tag);
        if (key == null) {
            return null;
        }
        return new GenericStack(key, tag.getLong("#"));
    }

    public static CompoundTag writeTag(@Nullable GenericStack stack) {
        if (stack == null) {
            return new CompoundTag();
        }
        CompoundTag tag = stack.what.toTagGeneric();
        tag.putLong("#", stack.amount);
        return tag;
    }

    @Nullable
    public static GenericStack fromItemStack(ItemStack stack) {
        GenericStack genericStack = GenericStack.unwrapItemStack(stack);
        if (genericStack != null) {
            return genericStack;
        }
        AEItemKey key = AEItemKey.of(stack);
        if (key == null) {
            return null;
        }
        return new GenericStack(key, stack.getCount());
    }

    @Nullable
    public static GenericStack fromFluidStack(FluidStack stack) {
        AEFluidKey key = AEFluidKey.of(stack);
        if (key == null) {
            return null;
        }
        return new GenericStack(key, stack.getAmount());
    }

    public static long getStackSizeOrZero(@Nullable GenericStack stack) {
        return stack == null ? 0L : stack.amount;
    }

    public static ItemStack wrapInItemStack(@Nullable GenericStack stack) {
        if (stack != null) {
            return GenericStack.wrapInItemStack(stack.what(), stack.amount());
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack wrapInItemStack(AEKey what, long amount) {
        return WrappedGenericStack.wrap(what, amount);
    }

    public static boolean isWrapped(ItemStack stack) {
        return stack.getItem() instanceof WrappedGenericStack;
    }

    public static GenericStack unwrapItemStack(ItemStack stack) {
        WrappedGenericStack item;
        AEKey what;
        Item item2;
        if (!stack.isEmpty() && (item2 = stack.getItem()) instanceof WrappedGenericStack && (what = (item = (WrappedGenericStack)item2).unwrapWhat(stack)) != null) {
            long amount = item.unwrapAmount(stack);
            return new GenericStack(what, amount);
        }
        return null;
    }

    public static GenericStack sum(GenericStack left, GenericStack right) {
        if (!left.what.equals(right.what)) {
            throw new IllegalArgumentException("Cannot sum generic stacks of " + left.what + " and " + right.what);
        }
        return new GenericStack(left.what, left.amount + right.amount);
    }
}

