/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class AEKey {
    private volatile Component cachedDisplayName;

    @Nullable
    public static AEKey fromTagGeneric(CompoundTag tag) {
        AEKeyType channel;
        String channelId = tag.getString("#c");
        if (channelId.isEmpty()) {
            AELog.warn("Cannot deserialize generic key from %s because key '#c' is missing.", tag);
            return null;
        }
        try {
            channel = AEKeyTypes.get(new ResourceLocation(channelId));
        }
        catch (IllegalArgumentException | ResourceLocationException e) {
            AELog.warn("Cannot deserialize generic key from %s because channel '%s' is missing.", tag, channelId);
            return null;
        }
        return channel.loadKeyFromTag(tag);
    }

    public static void writeOptionalKey(FriendlyByteBuf buffer, @Nullable AEKey key) {
        buffer.writeBoolean(key != null);
        if (key != null) {
            AEKey.writeKey(buffer, key);
        }
    }

    public static void writeKey(FriendlyByteBuf buffer, AEKey key) {
        byte id = key.getType().getRawId();
        buffer.writeVarInt((int)id);
        key.writeToPacket(buffer);
    }

    @Nullable
    public static AEKey readOptionalKey(FriendlyByteBuf buffer) {
        if (!buffer.readBoolean()) {
            return null;
        }
        return AEKey.readKey(buffer);
    }

    @Nullable
    public static AEKey readKey(FriendlyByteBuf buffer) {
        int id = buffer.readVarInt();
        AEKeyType type = AEKeyType.fromRawId(id);
        if (type == null) {
            AELog.error("Received unknown key space id %d", id);
            return null;
        }
        return type.readFromPacket(buffer);
    }

    public final CompoundTag toTagGeneric() {
        CompoundTag tag = this.toTag();
        tag.putString("#c", this.getType().getId().toString());
        return tag;
    }

    public final int getAmountPerUnit() {
        return this.getType().getAmountPerUnit();
    }

    @Nullable
    public final String getUnitSymbol() {
        return this.getType().getUnitSymbol();
    }

    public final int getAmountPerOperation() {
        return this.getType().getAmountPerOperation();
    }

    public final int getAmountPerByte() {
        return this.getType().getAmountPerByte();
    }

    public String formatAmount(long amount, AmountFormat format) {
        return this.getType().formatAmount(amount, format);
    }

    public abstract AEKeyType getType();

    public abstract AEKey dropSecondary();

    public abstract CompoundTag toTag();

    public abstract Object getPrimaryKey();

    public int getFuzzySearchValue() {
        return 0;
    }

    public int getFuzzySearchMaxValue() {
        return 0;
    }

    public final boolean fuzzyEquals(AEKey other, FuzzyMode fuzzyMode) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this.getPrimaryKey() != other.getPrimaryKey()) {
            return false;
        }
        if (!this.supportsFuzzyRangeSearch()) {
            return true;
        }
        if (fuzzyMode == FuzzyMode.IGNORE_ALL) {
            return true;
        }
        if (fuzzyMode == FuzzyMode.PERCENT_99) {
            return this.getFuzzySearchValue() > 0 == other.getFuzzySearchValue() > 0;
        }
        float percentA = (float)this.getFuzzySearchValue() / (float)this.getFuzzySearchMaxValue();
        float percentB = (float)other.getFuzzySearchValue() / (float)other.getFuzzySearchMaxValue();
        return percentA > fuzzyMode.breakPoint == percentB > fuzzyMode.breakPoint;
    }

    @Contract(value="null -> false")
    public final boolean matches(@Nullable GenericStack stack) {
        return stack != null && stack.what().equals(this);
    }

    public String getModId() {
        return this.getId().getNamespace();
    }

    public abstract ResourceLocation getId();

    public abstract void writeToPacket(FriendlyByteBuf var1);

    public ItemStack wrapForDisplayOrFilter() {
        return GenericStack.wrapInItemStack(this, 0L);
    }

    public final boolean supportsFuzzyRangeSearch() {
        return this.getType().supportsFuzzyRangeSearch();
    }

    public final Component getDisplayName() {
        Component ret = this.cachedDisplayName;
        if (ret == null) {
            this.cachedDisplayName = ret = this.computeDisplayName();
        }
        return ret;
    }

    protected abstract Component computeDisplayName();

    public abstract void addDrops(long var1, List<ItemStack> var3, Level var4, BlockPos var5);

    public boolean isTagged(TagKey<?> tag) {
        return false;
    }
}

