/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import appeng.util.Platform;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class AEFluidKey
extends AEKey {
    public static final int AMOUNT_BUCKET = 1000;
    public static final int AMOUNT_BLOCK = 1000;
    private final Fluid fluid;
    @Nullable
    private final CompoundTag tag;
    private final int hashCode;

    private AEFluidKey(Fluid fluid, @Nullable CompoundTag tag) {
        this.fluid = fluid;
        this.tag = tag;
        this.hashCode = Objects.hash(fluid, tag);
    }

    public static AEFluidKey of(Fluid fluid, @Nullable CompoundTag tag) {
        return new AEFluidKey(fluid, tag != null ? tag.copy() : null);
    }

    public static AEFluidKey of(Fluid fluid) {
        return AEFluidKey.of(fluid, null);
    }

    @Nullable
    public static AEFluidKey of(FluidStack fluidVariant) {
        if (fluidVariant.isEmpty()) {
            return null;
        }
        return AEFluidKey.of(fluidVariant.getFluid(), fluidVariant.getTag());
    }

    public static boolean matches(AEKey what, FluidStack fluid) {
        AEFluidKey fluidKey;
        return what instanceof AEFluidKey && (fluidKey = (AEFluidKey)what).matches(fluid);
    }

    public static boolean is(AEKey what) {
        return what instanceof AEFluidKey;
    }

    public static AEKeyFilter filter() {
        return AEFluidKey::is;
    }

    public boolean matches(FluidStack variant) {
        return !variant.isEmpty() && this.fluid.isSame(variant.getFluid()) && Objects.equals(this.tag, variant.getTag());
    }

    @Override
    public AEKeyType getType() {
        return AEKeyType.fluids();
    }

    @Override
    public AEFluidKey dropSecondary() {
        return AEFluidKey.of(this.fluid, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEFluidKey aeFluidKey = (AEFluidKey)o;
        return this.hashCode == aeFluidKey.hashCode && this.fluid == aeFluidKey.fluid && Objects.equals(this.tag, aeFluidKey.tag);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AEFluidKey fromTag(CompoundTag tag) {
        try {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.getOptional(new ResourceLocation(tag.getString("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown fluid id."));
            CompoundTag extraTag = tag.contains("tag") ? tag.getCompound("tag") : null;
            return AEFluidKey.of(fluid, extraTag);
        }
        catch (Exception e) {
            AELog.debug("Tried to load an invalid fluid key from NBT: %s", tag, e);
            return null;
        }
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag result = new CompoundTag();
        result.putString("id", BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        if (this.tag != null) {
            result.put("tag", (Tag)this.tag.copy());
        }
        return result;
    }

    @Override
    public Object getPrimaryKey() {
        return this.fluid;
    }

    @Override
    public ResourceLocation getId() {
        return BuiltInRegistries.FLUID.getKey((Object)this.fluid);
    }

    @Override
    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
    }

    @Override
    protected Component computeDisplayName() {
        return Platform.getFluidDisplayName(this.fluid, this.tag);
    }

    @Override
    public boolean isTagged(TagKey<?> tag) {
        return this.fluid.builtInRegistryHolder().is(tag);
    }

    public FluidStack toStack(int amount) {
        return new FluidStack(this.fluid, amount, this.tag);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    @Nullable
    public CompoundTag copyTag() {
        return this.tag != null ? this.tag.copy() : null;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf data) {
        data.writeVarInt(BuiltInRegistries.FLUID.getId((Object)this.fluid));
        data.writeNbt(this.tag);
    }

    public static AEFluidKey fromPacket(FriendlyByteBuf data) {
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.byId(data.readVarInt());
        CompoundTag tag = data.readNbt();
        return new AEFluidKey(fluid, tag);
    }

    public static boolean is(@Nullable GenericStack stack) {
        return stack != null && stack.what() instanceof AEFluidKey;
    }

    public String toString() {
        ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)this.fluid);
        String idString = id != BuiltInRegistries.FLUID.getDefaultKey() ? id.toString() : this.fluid.getClass().getName() + "(unregistered)";
        return this.tag == null ? idString : idString + " (+tag)";
    }
}

