/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.implementations.blockentities;

import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import appeng.core.localization.GuiText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public record PatternContainerGroup(@Nullable AEItemKey icon, Component name, List<Component> tooltip) {
    private static final PatternContainerGroup NOTHING = new PatternContainerGroup(AEItemKey.of((ItemLike)Items.AIR), (Component)GuiText.Nothing.text(), List.of());

    public static PatternContainerGroup nothing() {
        return NOTHING;
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.icon != null);
        if (this.icon != null) {
            this.icon.writeToPacket(buffer);
        }
        buffer.writeComponent(this.name);
        buffer.writeVarInt(this.tooltip.size());
        for (Component component : this.tooltip) {
            buffer.writeComponent(component);
        }
    }

    public static PatternContainerGroup readFromPacket(FriendlyByteBuf buffer) {
        AEItemKey icon = buffer.readBoolean() ? AEItemKey.fromPacket(buffer) : null;
        Component name = buffer.readComponent();
        int lineCount = buffer.readVarInt();
        ArrayList<Component> lines = new ArrayList<Component>(lineCount);
        for (int i = 0; i < lineCount; ++i) {
            lines.add(buffer.readComponent());
        }
        return new PatternContainerGroup(icon, name, lines);
    }

    @Nullable
    public static PatternContainerGroup fromMachine(Level level, BlockPos pos, Direction side) {
        Component name;
        AEItemKey icon;
        BlockEntity target = level.getBlockEntity(pos);
        ICraftingMachine craftingMachine = ICraftingMachine.of(level, pos, side, target);
        if (craftingMachine != null) {
            return craftingMachine.getCraftingMachineInfo();
        }
        if (target == null) {
            return null;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal(target, side);
        if (adaptor == null || !adaptor.mayAllowInsertion()) {
            return null;
        }
        List<Component> tooltip = List.of();
        if (target instanceof IPartHost) {
            IPartHost partHost = (IPartHost)target;
            IPart part = partHost.getPart(side);
            if (part == null) {
                return null;
            }
            icon = AEItemKey.of(part.getPartItem());
            if (part instanceof Nameable) {
                Nameable nameable = (Nameable)part;
                name = nameable.getDisplayName();
            } else {
                name = icon.getDisplayName();
            }
        } else {
            Nameable nameable;
            Block targetBlock = target.getBlockState().getBlock();
            ItemStack targetItem = new ItemStack((ItemLike)targetBlock);
            icon = AEItemKey.of(targetItem);
            if (target instanceof Nameable && (nameable = (Nameable)target).hasCustomName()) {
                name = nameable.getCustomName();
            } else {
                if (targetItem.isEmpty()) {
                    return null;
                }
                name = targetItem.getHoverName();
            }
        }
        return new PatternContainerGroup(icon, name, tooltip);
    }
}

