/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.blockentity.storage.SkyChestBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.storage.CreativeCellItem;
import appeng.me.helpers.BaseActionSource;
import appeng.menu.AutoCraftingMenu;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.DriveBuilder;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.TestCraftingJob;
import appeng.util.inv.AppEngInternalInventory;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class AutoCraftingTestPlots {
    private AutoCraftingTestPlots() {
    }

    @TestPlot(value="autocrafting_testplot")
    public static void create(PlotBuilder plot) {
        plot.creativeEnergyCell("4 -1 4");
        plot.cable("4 0 [1,5]");
        plot.cable("[3,6] 0 1");
        plot.block("[4,5] [0,1] [4,5]", AEBlocks.CONTROLLER);
        AutoCraftingTestPlots.craftingCube(plot.offset(1, 0, 1));
        plot.cable("[6,8] 0 5");
        PlotBuilder assemblerStack = plot.offset(8, 1, 5);
        for (int i = 0; i < 8; ++i) {
            AutoCraftingTestPlots.assemblerFlower(assemblerStack.offset(0, i * 3, 0));
        }
        plot.blockEntity("7 0 1", AEBlocks.DRIVE, drive -> {
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.FLUID_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.FLUID_CELL_64K.stack());
            drive.getInternalInventory().addItems(CreativeCellItem.ofItems(new ItemLike[]{Items.f_42451_}));
            drive.getInternalInventory().addItems(CreativeCellItem.ofFluids(new Fluid[]{Fluids.f_76195_}));
        });
        plot.part("6 0 1", Direction.NORTH, AEParts.PATTERN_ENCODING_TERMINAL, term -> {
            InternalInventory inv = term.getLogic().getBlankPatternInv();
            inv.addItems(AEItems.BLANK_PATTERN.stack(64));
        });
        plot.part("5 0 1", Direction.NORTH, AEParts.PATTERN_ACCESS_TERMINAL);
        plot.part("4 0 1", Direction.NORTH, AEParts.TERMINAL);
        plot.part("3 0 1", Direction.NORTH, AEParts.CRAFTING_TERMINAL);
        AutoCraftingTestPlots.buildObsidianCrafting(plot.offset(3, 0, 5));
        AutoCraftingTestPlots.buildChestCraftingExport(plot.offset(5, 0, 7));
        AutoCraftingTestPlots.buildWaterEmittingSource(plot.offset(5, 0, 9));
        plot.cable("4 0 [6,9]", AEParts.SMART_DENSE_CABLE);
        plot.afterGridInitAt("4 0 4", (grid, gridNode) -> {
            ServerLevel level = gridNode.getLevel();
            ArrayList<ItemStack> patterns = new ArrayList<ItemStack>();
            patterns.add(AutoCraftingTestPlots.encodeCraftingPattern(level, new Object[]{Items.f_42647_, Items.f_42647_, null, Items.f_42647_, Items.f_42797_, null, null, null, null}, true, false, "Dev"));
            patterns.add(AutoCraftingTestPlots.encodeCraftingPattern(level, new Object[]{Items.f_42647_, Items.f_42647_, Items.f_42647_, Items.f_42647_, null, Items.f_42647_, Items.f_42797_, Items.f_42647_, Items.f_42647_}, true, false, "Dev"));
            patterns.add(PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76193_), 1000L), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42451_))}, new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76193_), 1000L)}, "Dev"));
            MEStorage networkInv = grid.getStorageService().getInventory();
            networkInv.insert(AEItemKey.of((ItemLike)Items.f_42647_), 83L, Actionable.MODULATE, new BaseActionSource());
            block0: for (PatternProviderBlockEntity provider : grid.getMachines(PatternProviderBlockEntity.class)) {
                while (!patterns.isEmpty()) {
                    ItemStack pattern = (ItemStack)patterns.get(0);
                    if (!provider.getLogic().getPatternInv().addItems(pattern).m_41619_()) continue block0;
                    patterns.remove(0);
                }
            }
        });
    }

    private static void buildChestCraftingExport(PlotBuilder plot) {
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.EXPORT_BUS, eb -> {
            eb.getUpgrades().addItems(new ItemStack(AEItems.CRAFTING_CARD));
            eb.getConfig().insert(0, AEItemKey.of((ItemLike)Items.f_42009_), 1L, Actionable.MODULATE);
        });
        plot.block("0 0 1", Blocks.f_50087_);
    }

    private static void buildWaterEmittingSource(PlotBuilder plot) {
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.QUARTZ_FIBER);
        plot.cable("0 0 1").part(Direction.NORTH, AEParts.TOGGLE_BUS);
        plot.cable("0 1 0");
        plot.cable("0 1 1").craftingEmitter(Direction.DOWN, (Fluid)Fluids.f_76193_).part(Direction.SOUTH, AEParts.INTERFACE);
        plot.cable("0 1 2").part(Direction.NORTH, AEParts.STORAGE_BUS, storageBus -> storageBus.getConfig().insert(0, AEFluidKey.of((Fluid)Fluids.f_76193_), 1L, Actionable.MODULATE));
        plot.cable("0 0 2").part(Direction.DOWN, AEParts.ANNIHILATION_PLANE);
        plot.block("[-1,1] -1 2", Blocks.f_49990_);
    }

    private static void buildObsidianCrafting(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.PATTERN_PROVIDER, provider -> {
            ItemStack pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((Fluid)Fluids.f_76195_), 1000L)}, new GenericStack[]{new GenericStack(AEItemKey.of((ItemLike)Items.f_41999_), 1L)}, "Dev");
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.cable("-1 0 0").part(Direction.EAST, AEParts.INTERFACE).part(Direction.WEST, AEParts.FORMATION_PLANE, plane -> plane.getConfig().insert(0, AEFluidKey.of((Fluid)Fluids.f_76195_), 1L, Actionable.MODULATE));
        plot.cable("-2 1 0").part(Direction.DOWN, AEParts.ANNIHILATION_PLANE);
        plot.cable("-1 1 0").part(Direction.DOWN, AEParts.QUARTZ_FIBER);
        plot.cable("0 1 0").part(Direction.DOWN, AEParts.STORAGE_BUS, part -> part.getConfig().insert(0, AEItemKey.of((ItemLike)Items.f_41999_), 1L, Actionable.MODULATE)).part(Direction.EAST, AEParts.QUARTZ_FIBER);
        plot.block("-3 0 [-2,0]", Blocks.f_50652_);
        plot.block("-1 0 [-2,-1]", Blocks.f_50652_);
        plot.block("-2 0 1", Blocks.f_50652_);
        plot.block("-2 0 -2", Blocks.f_49990_);
    }

    private static ItemStack encodeCraftingPattern(ServerLevel level, Object[] ingredients, boolean allowSubstitutions, boolean allowFluidSubstitutions, String author) {
        ItemStack[] stacks = (ItemStack[])Arrays.stream(ingredients).map(in -> {
            if (in instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)in;
                return new ItemStack(itemLike);
            }
            if (in instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)in;
                return itemStack;
            }
            if (in == null) {
                return ItemStack.f_41583_;
            }
            throw new IllegalArgumentException("Unsupported argument: " + in);
        }).toArray(ItemStack[]::new);
        TransientCraftingContainer c = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
        for (int i = 0; i < stacks.length; ++i) {
            c.m_6836_(i, stacks[i]);
        }
        CraftingRecipe recipe = (CraftingRecipe)level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)c, (Level)level).orElseThrow();
        ItemStack result = recipe.m_5874_((Container)c, level.m_9598_());
        return PatternDetailsHelper.encodeCraftingPattern(recipe, stacks, result, allowSubstitutions, allowFluidSubstitutions, author);
    }

    private static void craftingCube(PlotBuilder plot) {
        plot.block("[-1,1] [0,2] [-1,1]", AEBlocks.CRAFTING_STORAGE_64K);
        plot.block("-1 2 -1", AEBlocks.CRAFTING_STORAGE_16K);
        plot.block("1 2 -1", AEBlocks.CRAFTING_STORAGE_4K);
        plot.block("-1 2 1", AEBlocks.CRAFTING_STORAGE_1K);
        plot.block("[-1,1] 0 [-1,1]", AEBlocks.CRAFTING_ACCELERATOR);
        plot.block("0 1 -1", AEBlocks.CRAFTING_MONITOR);
    }

    private static void assemblerFlower(PlotBuilder plot) {
        plot.block("0 0 0", AEBlocks.PATTERN_PROVIDER);
        plot.block("-1 0 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("1 0 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 0 1", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 0 -1", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 -1 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 1 0", AEBlocks.MOLECULAR_ASSEMBLER);
    }

    @TestPlot(value="pattern_provider_faces_round_robin")
    public static void patternProviderFacesRoundRobin(PlotBuilder plot) {
        BlockPos[] inscriberPos = new BlockPos[]{new BlockPos(-1, 0, -3), new BlockPos(1, 0, -3)};
        AutoCraftingTestPlots.craftingCube(plot);
        plot.cable("0 0 -2");
        plot.blockEntity("0 0 -3", AEBlocks.PATTERN_PROVIDER, provider -> {
            ItemStack pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{GenericStack.fromItemStack(AEItems.CERTUS_QUARTZ_CRYSTAL.stack())}, new GenericStack[]{GenericStack.fromItemStack(AEItems.CERTUS_QUARTZ_DUST.stack())}, "Dev");
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        for (BlockPos pos : inscriberPos) {
            plot.blockEntity(pos, AEBlocks.INSCRIBER, inscriber -> inscriber.getConfigManager().putSetting(Settings.AUTO_EXPORT, YesNo.YES));
        }
        plot.cable("0 0 -4");
        DriveBuilder db = plot.drive(new BlockPos(0, 0, -5));
        db.addCreativeCell().add(AEItems.CERTUS_QUARTZ_CRYSTAL);
        db.addItemCell64k();
        plot.cable("0 1 -5").part(Direction.NORTH, AEParts.CRAFTING_TERMINAL);
        plot.creativeEnergyCell("0 -1 -5");
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), BlockPos.f_121853_, AEItemKey.of(AEItems.CERTUS_QUARTZ_DUST), 10L);
            helper.m_177425_().m_177552_(craftingJob::tickUntilStarted).m_177544_(1).m_177562_(() -> {
                for (BlockPos pos : inscriberPos) {
                    InscriberBlockEntity inscriber = (InscriberBlockEntity)helper.m_177347_(pos);
                    helper.check(inscriber.getInternalInventory().getStackInSlot(2).m_41613_() == 5, "Inscriber should have 5 = 10/2 items", pos);
                }
            }).m_177543_();
        });
    }

    @TestPlot(value="processing_pattern_inputs_unstacking")
    public static void processingPatternInputsUnstacking(PlotBuilder plot) {
        BlockPos chestPos = new BlockPos(1, 0, -3);
        AutoCraftingTestPlots.craftingCube(plot);
        plot.cable("0 0 -2");
        plot.blockEntity("0 0 -3", AEBlocks.PATTERN_PROVIDER, provider -> {
            ItemStack pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_41905_)), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_41905_)), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42415_)), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_41905_))}, new GenericStack[]{GenericStack.fromItemStack(AEItems.CERTUS_QUARTZ_DUST.stack())}, "Dev");
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.blockEntity(chestPos, AEBlocks.SKY_STONE_CHEST, skyChest -> {
            AppEngInternalInventory inv = (AppEngInternalInventory)skyChest.getInternalInventory();
            for (int i = 0; i < inv.size(); ++i) {
                inv.setMaxStackSize(i, 1);
            }
        });
        plot.cable("0 0 -4");
        DriveBuilder db = plot.drive(new BlockPos(0, 0, -5));
        db.addCreativeCell().add((ItemLike)Items.f_41905_).add((ItemLike)Items.f_42415_);
        db.addItemCell64k();
        plot.cable("0 1 -5").part(Direction.NORTH, AEParts.CRAFTING_TERMINAL);
        plot.creativeEnergyCell("0 -1 -5");
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), BlockPos.f_121853_, AEItemKey.of(AEItems.CERTUS_QUARTZ_DUST), 1L);
            helper.m_177425_().m_177552_(craftingJob::tickUntilStarted).m_177544_(1).m_177562_(() -> {
                SkyChestBlockEntity chest = (SkyChestBlockEntity)helper.m_177347_(chestPos);
                InternalInventory inv = chest.getInternalInventory();
                for (int i = 0; i < 4; ++i) {
                    helper.check(inv.getStackInSlot(i).m_41613_() == 1, "Chest should have 1 item in slot " + i, chestPos);
                }
                helper.check(inv.getStackInSlot(0).m_150930_(Items.f_41905_), "Chest should have stone in slot 0", chestPos);
                helper.check(inv.getStackInSlot(1).m_150930_(Items.f_41905_), "Chest should have stone in slot 1", chestPos);
                helper.check(inv.getStackInSlot(2).m_150930_(Items.f_42415_), "Chest should have diamond in slot 2", chestPos);
                helper.check(inv.getStackInSlot(3).m_150930_(Items.f_41905_), "Chest should have stone in slot 3", chestPos);
            }).m_177543_();
        });
    }

    @TestPlot(value="regression_7288")
    public static void testCraftingCpuDupe(PlotBuilder plot) {
        AutoCraftingTestPlots.craftingCube(plot);
        plot.cable("0 0 -2");
        plot.blockEntity("0 0 -3", AEBlocks.PATTERN_PROVIDER, provider -> {
            ItemStack pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42415_))}, new GenericStack[]{GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42398_))}, "Dev");
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.cable("0 0 -4");
        DriveBuilder db = plot.drive(new BlockPos(0, 0, -5));
        db.addItemCell64k().add((ItemLike)Items.f_42415_, 1L);
        plot.cable("0 1 -5").part(Direction.NORTH, AEParts.CRAFTING_TERMINAL);
        plot.creativeEnergyCell("0 -1 -5");
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), BlockPos.f_121853_, AEItemKey.of((ItemLike)Items.f_42398_), 1L);
            helper.m_177425_().m_177552_(craftingJob::tickUntilStarted).m_177544_(1).m_177562_(() -> {
                helper.m_177434_(new BlockPos(0, 0, -2));
                helper.m_177434_(new BlockPos(0, 0, -1));
                helper.m_177198_(Items.f_42415_, new BlockPos(0, 0, 0), 3.0, 1);
            }).m_177543_();
        });
    }
}

